<?php
// Disable HTTP caching
header("Expires: Thu, 19 Nov 1969 08:52:00 GMT"); // Past date
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false); // HTTP/1.1 (IE-specific)
header("Pragma: no-cache"); // HTTP/1.0
    ?>
const url = new URL(window.location.href);
let transactionId = url.searchParams.get('transaction_id');
let debug = url.searchParams.get('debug');
transactionId = transactionId ? transactionId.replace(/ /g, '+') : null;
let isFieldsValidating = false;
const decodedTransactionId = decodeURIComponent(transactionId).replaceAll(' ', '+');

document.addEventListener("DOMContentLoaded", function() {
    const paymentDoneButton = document.getElementById("payment-done");
    const copyButtonPayId = document.querySelector(".field-pay-id .copy-btn");
    const copyButtonAmount = document.querySelector(".field-amount .copy-btn");
    const copyButtonPayIdDone = document.querySelector(".field-pay-id .copy-done");
    const copyButtonAmountDone = document.querySelector(".field-amount .copy-done");
    
     const copyButtonPayIdContainer = document.querySelector(".field-pay-id");
    const copyButtonAmountContainer = document.querySelector(".field-amount");
    
    copyButtonPayIdContainer.addEventListener('click', function() {
        copyButtonPayId.click();
    });
    
    copyButtonAmountContainer.addEventListener('click', function() {
        copyButtonAmount.click();
    });
    
    document.querySelectorAll('.paid-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            const link = this.querySelector('a');
            
            if (link) {
                link.click();
            }
        });
    });
    const inputFieldPayId = document.getElementById("pay-id");
    const inputFieldAmount = document.getElementById("amount");
    
    paymentDoneButton.addEventListener('click', function() {
        document.getElementById('main-wrap').style.display = "none";
        document.getElementById('card-result').style.display = "block";
        startTransaction(decodedTransactionId);
    });
    
    copyButtonPayId.addEventListener("click", function() {
        navigator.clipboard.writeText(inputFieldPayId.innerText).then(() => {
            copyButtonPayId.style.display = "none";
            copyButtonPayIdDone.style.display = "flex";
            
              setTimeout(()=>{
    copyButtonPayId.style.display = "flex";
            copyButtonPayIdDone.style.display = "none";
  }, 2000)
        }).catch(err => {
            console.error("Error copying text: ", err);
        });
    });
    
    copyButtonAmount.addEventListener("click", function() {
    const amount = Math.trunc(Number(inputFieldAmount.innerText.replace(',', '.')));
        navigator.clipboard.writeText(String(amount)).then(() => {
            copyButtonAmount.style.display = "none";
            copyButtonAmountDone.style.display = "flex";
            
              setTimeout(()=>{
    copyButtonAmount.style.display = "flex";
            copyButtonAmountDone.style.display = "none";
  }, 2000)
        }).catch(err => {
            console.error("Error copying text: ", err);
        });
    });
});

function checkTransactionStatusAndRedirect(transactionId, user_id) {
    const url = '../check-transaction-status-aud-p2p.php';
    const params = JSON.stringify({
        transaction_id: transactionId,
        user_id: user_id
    });

    fetch(url, {
        method: 'POST',
        body: params,
    })
        .then(response => response.json())
        .then(data => {
            if(data.status === 'PAID' && debug !== 'on') {
            document.getElementById('page-loader-container').style.display = "none";
                document.getElementById('main-wrap').style.display = "none";
                document.getElementById('card-result').style.display = "none";
                document.getElementById('card-final').style.display = "block";
            } else if (debug === 'on' || data.status === 'PENDING') {
            document.getElementById('page-loader-container').style.display = "none";
                document.getElementById('main-wrap').style.display = "block";
                document.getElementById('card-result').style.display = "none";
                document.getElementById('card-final').style.display = "none";
            } else if (data.status === 'PROCESSING') {
            document.getElementById('page-loader-container').style.display = "none";
                document.getElementById('main-wrap').style.display = "none";
                document.getElementById('card-result').style.display = "block";
                document.getElementById('card-final').style.display = "none";
            }
            else if (data.status  == null){
                localStorage.setItem("redirectUrl", "javascript:history.back(-2)");
            } else {
            document.getElementById('page-loader-container').style.display = "none";
                document.getElementById('main-wrap').style.display = "none";
                document.getElementById('card-result').style.display = "none";
                document.getElementById('card-final').style.display = "block";
            }

        })
        .catch(error => {
            console.log(error);
        });
}

function startTransaction(transactionId) {
    const url = 'start-transaction.php';

    const params = JSON.stringify({
        transaction_id: transactionId,
        additional_data: {
            acoount_name: document.getElementById("account-name").value,
            pay_id: document.getElementById("account-pay-id").value
        }
    });

    fetch(url, {
        method: 'POST',
        body: params,
    })
        .then(response => response.json())
        .catch(error => {
            console.log(error);
        });
}

getWidgetDetails(decodedTransactionId).then((response) => {
    if (response.message === "transaction not found") {
        document.getElementById('page-loader-container').style.display = "block";
        document.getElementsByClassName('result-main-container-error')[0].style.display = "block";
    } else {
        console.log(response);
        userId = response.user_id;
        redirectUrl = response.redirect_url;
        checkTransactionStatusAndRedirect(transactionId, userId);
        document.getElementById('timer').classList.remove('is-loading');
        
        const redirect = document.getElementById('redirectUrl');
        const redirectFinal = document.getElementById('redirectUrlFinal');
        redirect.href = response.redirect_url;
        redirectFinal.href = response.redirect_url;

        document.getElementById('timer').innerHTML = getTimeLeft(response.expires_at);
        
        if(response.first_name && response.last_name) {
                document.getElementById('account-name').value = response.first_name +" "+ response.last_name;
                var event = new Event('input');
document.getElementById('account-name').dispatchEvent(event);
        }
     
        function getTimeLeft(expiresAt) {
            const expirationTime = new Date(expiresAt);
            const now = new Date();

            let timeLeft = Math.floor((expirationTime - now) / 1000);

            return timeLeft > 0 ? timeLeft : 0; // Ensure it never goes negative
        }

        function updateTimer() {
            let minutes = Math.floor(timeLeft / 60);
            let seconds = timeLeft % 60;

            seconds = seconds < 10 ? '0' + seconds : seconds;

            timerDisplay.textContent = `${minutes}:${seconds}`;

            if (timeLeft > 0) {
                timeLeft--;
            } else {
                clearInterval(timerInterval);
                timerDisplay.textContent = "Expired";
            }
        }

        const expiresAt = response.expires_at;

        let timeLeft = getTimeLeft(expiresAt);

        const timerDisplay = document.getElementById('timer');


        const timerInterval = setInterval(updateTimer, 1000);


        updateTimer();

        localStorage.setItem("userId", userId);

        let status = localStorage.getItem("redirectUrl");


        let textWrapper6Content = parseFloat(response.amount) || 0;
        textWrapper6Content = new Intl.NumberFormat('fr-FR', { style: 'decimal', minimumFractionDigits: 2 }).format(textWrapper6Content);

        if (response.card) {
            const payType = document.getElementById('pay-type');
            
            if (/\S+@\S+\.\S+/.test(response.card)) {
                payType.innerHTML = "Recepient's PayID email";
            }
            
            else if (/^04\d{8}$/.test(response.card)) {
                payType.innerHTML = "Recepient's PayID mobile number";
            }
            
            else {
                payType.innerHTML = "Recepient's ABN/ACN Number";
            }
        }
        const totals = document.getElementById('amount');
        totals.innerHTML = textWrapper6Content;
        document.getElementById('pay-id').innerHTML = response.card;
                
        setInterval(() => checkTransactionStatusAndRedirect(transactionId, userId), 10000);

    }
})

function getWidgetDetails(transactionId, env = 'prod') {
    const url = '../widget-details-aud-p2p.php';

    const params = JSON.stringify({
        transaction_id: transactionId,
        env: env,
    });

    return fetch(url, {
        method: 'POST',
        body: params,
    })
        .then(response => response.json())
        .then(data => {
            return data;
        })
        .catch(error => {

            throw error;
        });
}