<?php
// Disable HTTP caching
header("Expires: Thu, 19 Nov 1969 08:52:00 GMT"); // Past date
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false); // HTTP/1.1 (IE-specific)
header("Pragma: no-cache"); // HTTP/1.0
?>
  
document.addEventListener("DOMContentLoaded", function() {
    const copyButton = document.querySelector(".pocket-address-input .copy");
    const copyButtonAlias = document.querySelector(".recipient-alias-info .copy");
    const stepFormButtonSubmit = document.querySelector(".step-form-button-submit");
    const copyDone = document.querySelector(".pocket-address-input .copy-done");
    const copyDoneAlias = document.querySelector(".recipient-alias-info .copy-done");
    const inputField = document.getElementById("payment-id");
    const inputFieldAlias = document.getElementById("recipient-alias");

setTimeout(() => {
                stepFormButtonSubmit.classList.add('active');
                stepFormButtonSubmit.removeAttribute("disabled");
            }, 30000);
            
    document.getElementById('btn-modal').addEventListener('click', function() {
        document.getElementById('overlay').classList.add('is-visible');
        document.getElementById('modal').classList.add('is-visible');
    });

    document.getElementById('btn-modal-next').addEventListener('click', function() {
        document.getElementById('overlay').classList.add('is-visible');
        document.getElementById('modal').classList.add('is-visible');
    });

    document.getElementById('close-btn').addEventListener('click', function() {
        document.getElementById('overlay').classList.remove('is-visible');
        document.getElementById('modal').classList.remove('is-visible');
    });
    document.getElementById('overlay').addEventListener('click', function() {
        document.getElementById('overlay').classList.remove('is-visible');
        document.getElementById('modal').classList.remove('is-visible');
    });

    inputField.addEventListener("click", function() {
            stepFormButtonSubmit.classList.add('active');
                    stepFormButtonSubmit.removeAttribute("disabled");
        });
    copyButton.addEventListener("click", function() {
        navigator.clipboard.writeText(inputField.innerText).then(() => {
            copyButton.style.display = "none";
            copyDone.style.display = "flex";
            
              setTimeout(()=>{
    copyButton.style.display = "flex";
            copyDone.style.display = "none";
                }, 2000);

            setTimeout(() => {
                stepFormButtonSubmit.classList.add('active');
                stepFormButtonSubmit.removeAttribute("disabled");
            }, 1000);
        
			
        }).catch(err => {
            console.error("Error copying text: ", err);
        });
    });
    copyButtonAlias.addEventListener("click", function() {
        navigator.clipboard.writeText(inputFieldAlias.innerText).then(() => {
            copyButtonAlias.style.display = "none";
            copyDoneAlias.style.display = "flex";
            
              setTimeout(()=>{
    copyButtonAlias.style.display = "flex";
            copyDoneAlias.style.display = "none";
  }, 2000)

            setTimeout(() => {
                stepFormButtonSubmit.classList.add('active');
                stepFormButtonSubmit.removeAttribute("disabled");
            }, 1000);
        }).catch(err => {
            console.error("Error copying text: ", err);
        });
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("step-info-input");
    const inputTaxId = document.getElementById("step-info-input-tax-id");
    const stepInfoTaxId = document.querySelector(".customer-step-info-tax-id");
    const loader = document.querySelector(".customer-step-info-label svg");
    let stepInfo = document.querySelector(".customer-step-info-name");
    const error = document.querySelector(".error-message");
    const descriptionContainer = document.querySelector(".customer-step-info-description-container");
    const stepFormButtonSubmitSave = document.getElementById("step-form-button-submit-save");
    
    const inputEmail = document.getElementById("step-info-input-email");
    const stepInfoEmail = document.querySelector(".customer-step-info-email");
    
    const inputPhone = document.getElementById("step-info-input-phone");
    const stepInfoPhone = document.querySelector(".customer-step-info-phone");
    
            function validateCuit(cuit) {
  const validTypes = [20, 23, 24, 27, 30, 33, 34];
  const multipliers = [5, 4, 3, 2, 7, 6, 5, 4, 3, 2];
  const number = cuit.replace(/-/g, '').trim();
  if (number.length !== 11) return false;
  const typePrefix = parseInt(number.slice(0, 2), 10);
  if (!validTypes.includes(typePrefix)) return false;
  let sum = 0;
  for (let i = 0; i < 10; i++) {
    sum += parseInt(number[i], 10) * multipliers[i];
  }
  let checksum = 11 - (sum % 11);
  if (checksum === 11) checksum = 0;
  else if (checksum === 10) checksum = 9;
  return checksum === parseInt(number[10], 10);
}

function checkCuit() {
  const input = document.getElementById('step-info-input-tax-id').value;
  const isValid = validateCuit(input);
  const taxMainContainer = document.getElementById('customer-step-info-tax-id-container');
  
    const taxInfoSvgContainer = document.getElementById('info-svg-container');
    
      const taxInfoSvgContainerError = document.getElementById('info-svg-container-error');
      
      
  const stepFormButtonSubmitSave = document.getElementById("step-form-button-submit-save");

  document.getElementById('customer-step-info-description-validation').textContent = isValid ? "Identificación fiscal válida" : "Identificación fiscal no válida";
  
  if (isValid) {
                stepInfoTaxId.classList.add("correct");
                stepFormButtonSubmitSave.classList.add('active');
                stepFormButtonSubmitSave.removeAttribute("disabled");
                taxMainContainer.classList.remove('wrong-data');
                taxInfoSvgContainerError.classList.add('hidden');
                taxInfoSvgContainer.classList.remove('hidden');
            } else {
                stepFormButtonSubmitSave.classList.remove('active');
                stepFormButtonSubmitSave.setAttribute("disabled", "");
                stepInfoTaxId.classList.remove("correct");
                taxMainContainer.classList.add('wrong-data');
                taxInfoSvgContainerError.classList.remove('hidden');
                taxInfoSvgContainer.classList.add('hidden');
            }
        
}

    stepFormButtonSubmitSave.addEventListener('click', function() {
     document.querySelector(".customer-step-info-description-container-success").style.display = "flex";
     input.setAttribute("readonly", "");
     input.classList.add("validation-success");
        stepFormButtonSubmitSave.classList.remove('active');
                stepFormButtonSubmitSave.setAttribute("disabled", "");
    });
    
    if(!stepInfo) {
        stepInfo = document.querySelector(".customer-step-info");
    }
    
        function isFirstCharLetter(str) {
    return /^[a-zA-Z]/.test(str);
}

    input.addEventListener("input", function () {
        loader.style.display = "flex";

        const inputValue = input.value.trim();
        const words = inputValue.split(/\s+/);
        
        if (words.length >= 1 && isFirstCharLetter(words)) {
            error.style.display = "none";
            stepInfo.classList.add("correct");
            stepInfo.classList.remove("wrong-data");
            stepFormButtonSubmitSave.classList.add('active');
            stepFormButtonSubmitSave.removeAttribute("disabled");
        } else if (inputValue.length > 0) {
            error.style.display = "flex";
            stepInfo.classList.add("wrong-data");
            stepInfo.classList.remove("correct");
            stepFormButtonSubmitSave.classList.remove('active');
            stepFormButtonSubmitSave.setAttribute("disabled", "");
        }
        
        if (inputValue.length > 0) {
            descriptionContainer.style.display = "none";
        } else {
            descriptionContainer.style.display = "flex";
            error.style.display = "none";
            stepInfo.classList.remove("wrong-data");
            stepInfo.classList.remove("correct");
        }
     
    });
    
    if(inputTaxId) {
        inputTaxId.addEventListener("input", function () {
            checkCuit();
        });
    }

    if(inputEmail) {
        inputEmail.addEventListener("input", function () {
    
            const inputValue = inputEmail.value.trim();
            
            if (inputValue.length > 0) {
                stepInfoEmail.classList.add("correct");
                stepFormButtonSubmitSave.classList.add('active');
                stepFormButtonSubmitSave.removeAttribute("disabled");
            } else {
                stepFormButtonSubmitSave.classList.remove('active');
                stepFormButtonSubmitSave.setAttribute("disabled", "");
                stepInfoEmail.classList.remove("correct");
            }
         
        });
    }
    
    if(inputPhone) {
        inputPhone.addEventListener("input", function () {
    
            const inputValue = inputPhone.value.trim();
            
            if (inputValue.length > 0) {
                stepInfoPhone.classList.add("correct");
                stepFormButtonSubmitSave.classList.add('active');
                stepFormButtonSubmitSave.removeAttribute("disabled");
            } else {
                stepFormButtonSubmitSave.classList.remove('active');
                stepFormButtonSubmitSave.setAttribute("disabled", "");
                stepInfoPhone.classList.remove("correct");
            }
         
        });
    }
});