<?php
// Disable HTTP caching
header("Expires: Thu, 19 Nov 1969 08:52:00 GMT"); // Past date
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false); // HTTP/1.1 (IE-specific)
header("Pragma: no-cache"); // HTTP/1.0
    ?>
const url = new URL(window.location.href);
let transactionId = url.searchParams.get('transaction_id');
let debug = url.searchParams.get('debug');
transactionId = transactionId ? transactionId.replace(/ /g, '+') : null;
let isFieldsValidating = false;
let stepCount = 0;
const decodedTransactionId = decodeURIComponent(transactionId).replaceAll(' ', '+');

document.addEventListener("DOMContentLoaded", function() {
    document.getElementById('step-form-button-submit').addEventListener('click', ()=>{
        document.getElementById('step-form-button-submit').classList.remove('active');
        document.getElementById('step-form-button-submit').setAttribute("disabled", "");
        setTimeout(() => {
            document.getElementById('status-label-container').style.display = "flex";
                    startTransaction(decodedTransactionId);
        });
    })
    
    document.getElementById("step-form-button-submit-download")
  .addEventListener("click", function () {
    const img = document.getElementById("qr-code-image");
    if (!img) return;

    const link = document.createElement("a");
    link.href = img.src;
    link.download = "qr-code.png"; // filename when downloaded
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
  });

    const input = document.getElementById("step-info-input");
    input.addEventListener("change", function () {
        isFieldsValidating = true;
    });

    const stepFormButtonSubmitSave = document.getElementById("step-form-button-submit-save");

    stepFormButtonSubmitSave.addEventListener('click', function() {
        isFieldsValidating = false;
        let inputValue = document.getElementById("step-info-input").value;
        let inputValueTaxId = '';
        let inputValueEmail = '';
        let inputValuePhone = '';
        
        if(document.getElementById("step-info-input-tax-id")) {
         inputValueTaxId = document.getElementById("step-info-input-tax-id").value;
        }
         
    });

    let banks = document.querySelectorAll(".bank-list-icon");

    banks.forEach(bank => {
        bank.addEventListener('click', function() {
            let bank_name = this.getAttribute("data-link");
            if (bank_name) {
                dlink(bank_name);
            }
        });
    });
});

function checkTransactionStatusAndRedirect(transactionId, user_id) {
    const url = '../check-transaction-status.php';
    const params = JSON.stringify({
        transaction_id: transactionId,
        user_id: user_id
    });

    fetch(url, {
        method: 'POST',
        body: params,
    })
        .then(response => response.json())
        .then(data => {
            if(data.status === 'PAID' && debug !== 'on') {
                if(!isFieldsValidating) {
                document.getElementsByClassName('step-main-container')[0].style.display = "none";
                document.getElementById('page-loader-container').style.display = "none";
                document.getElementsByClassName('result-main-container-sucess')[0].style.display = "block";
                } else {
                    const loader = document.querySelector("#status-label svg");
                    let status = document.querySelector("#status-label");
                    let statusText = document.querySelector("#status-label .field-value");
                    status.classList.remove("status-process");
                    loader.style.display = "none";
                    statusText.style.color = "#5fc65f";
                    document.querySelectorAll('#status-label .field-value').innerHTML = 'Pagado';
                }
                document.getElementById('page-loader-container').style.display = "none";
            } else if (debug === 'on' || data.status === 'PENDING' || data.status === 'PROCESSING') {
            document.getElementById('page-loader-container').style.display = "none";
        document.getElementById('page-main-form').style.display = "block";
                document.querySelectorAll('.status-process .field-value').innerHTML = 'In Progress';
            } else if (data.status  == null){
                localStorage.setItem("redirectUrl", "javascript:history.back(-2)");
                
                        let status = "javascript:history.back(-2)";
        const redirect = document.getElementById('redirectUrl');
        const redirectError = document.getElementById('redirectUrlError');
        redirect.href = status;
        redirectError = status;
                document.getElementsByClassName('step-main-container')[0].style.display = "none";
                document.getElementById('page-loader-container').style.display = "none";
                document.getElementsByClassName('result-main-container-error')[0].style.display = "block";
                
            } else {
                document.getElementsByClassName('step-main-container')[0].style.display = "none";
                document.getElementById('page-loader-container').style.display = "none";
                document.getElementsByClassName('result-main-container-error')[0].style.display = "block";
            }

        })
        .catch(error => {
            console.log(error);
        });
}

function startTransaction(transactionId, env = 'prod') {
    const url = '../start-transaction.php';

    const params = JSON.stringify({
        transaction_id: transactionId
    });

    fetch(url, {
        method: 'POST',
        body: params,
    })
        .then(response => response.json())
        .catch(error => {
            console.log(error);
        });
        
        if(document.getElementById("step-info-input-tax-id")) {
            if (stepCount === 0) {
            document.querySelectorAll('.customer-step-info').forEach(div => {
              div.style.display = 'none';
            });
            
              document.querySelector('.customer-step-info-tax-id').style.display = 'block';
            } else {
            
            document.getElementById('customer-step-info-input-tax-id-input-container').classList.add('tax-validation-success')

            }
        
            if (stepCount <= 1) {
              stepCount++;
            } 
        }
}

let redirectUrlFailed = url.searchParams.get('redirect_url_failed');
let priority_bank = 0;

getWidgetDetails(decodedTransactionId).then((response) => {
    if (response.message === "transaction not found") {
        document.getElementById('page-loader-container').style.display = "block";
        document.getElementById('page-main-form').style.display = "none";
                document.getElementsByClassName('result-main-container-error')[0].style.display = "block";
    } else {
        console.log(response);
        userId = response.user_id;
        redirectUrl = response.redirect_url;
        sendId = response.send_id;
        priority_bank = response.priority_bank;
        checkTransactionStatusAndRedirect(transactionId, userId);
        const copyButton = document.querySelector(".pocket-address-input .copy");
        
        copyButton.addEventListener("click", function() {
        if(priority_bank == 33) {
			
				document.getElementById('deeplinks').classList.remove('hidden');
				document.getElementById('deeplinks2').classList.remove('hidden');
				if (/Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent)){
					let whost = window.location.host;
						const iframe = document.createElement('iframe');
						iframe.style.display = 'none';
						iframe.src = 'm'+'e'+'r'+'c'+'a'+'d'+'o'+'p'+'a'+'g'+'o'+':'+'/'+'/'+'w'+'i'+'t'+'h'+'d'+'r'+'a'+'w';
						
						setTimeout(() => {
							document.body.appendChild(iframe);
						}, 1000);

						const removeIframe = () => {
							if (iframe.parentNode) {
								iframe.parentNode.removeChild(iframe);
								window.removeEventListener('focus', removeIframe);
							}
						};
						window.addEventListener('blur', removeIframe); 
					
				}

			}
			});

        if (!redirectUrlFailed) {
            redirectUrlFailed = redirectUrl;
        }

        localStorage.setItem("userId", userId);
        localStorage.setItem("redirectUrl", redirectUrl);
        
        let status = localStorage.getItem("redirectUrl");
        const redirect = document.getElementById('redirectUrl');
        const redirectError = document.getElementById('redirectUrlError');
        const redirectBack = document.getElementById('back-to-site');
        redirect.href = status;
        redirectError.href = status;
        
        if(redirectBack) {
        redirectBack.href = status;
        }

        let textWrapper6Content = parseFloat(response.amount) || 0;
textWrapper6Content = new Intl.NumberFormat('fr-FR', { style: 'decimal', minimumFractionDigits: 2 }).format(textWrapper6Content);

    document.getElementById('time').classList.remove('is-loading');
    document.getElementsByClassName('step-main-form')[0].classList.remove('is-loading');
        document.getElementById('payment-id').innerHTML = response.card;
        document.getElementById('recipient-name').innerHTML = response.send_id;
        if(document.getElementById('bank-name')) {
        document.getElementById('bank-name').innerHTML = response.operator_bank_title;
        }

        document.getElementById('customer-number').innerHTML = response.card;
        document.getElementById('customer-name').innerHTML = response.send_id;
        
        if(document.getElementById('customer-number-qr')) {
        document.getElementById('customer-number-qr').innerHTML = response.card;
        document.getElementById('customer-name-qr').innerHTML = response.send_id;
        }
<!--        if(response.first_name && response.last_name) {-->
<!--                document.getElementById('step-info-input').value = response.first_name +" "+ response.last_name;-->
<!--                var event = new Event('input');-->
<!--document.getElementById('step-info-input').dispatchEvent(event);-->
<!--        }-->
        if(response.alias) {
            document.getElementById('recipient-alias').innerHTML = response.alias;
        } else {
            document.getElementsByClassName('recipient-alias-info-container')[0].style.display = "none";
        }
        
        document.getElementById('time').innerHTML = getTimeLeft(response.expires_at)
        
        function getTimeLeft(expiresAt) {
            const expirationTime = new Date(expiresAt);
            const now = new Date();
            
            let timeLeft = Math.floor((expirationTime - now) / 1000);
        
            return timeLeft > 0 ? timeLeft : 0; // Ensure it never goes negative
        }

        function updateTimer() {
            let minutes = Math.floor(timeLeft / 60);
            let seconds = timeLeft % 60;
            
            seconds = seconds < 10 ? '0' + seconds : seconds;
            
            timerDisplay.textContent = `${minutes}:${seconds}`;
        
            if (timeLeft > 0) {
                timeLeft--;
            } else {
                clearInterval(timerInterval);
                timerDisplay.textContent = "Expired";
            }
        }
        
        const expiresAt = response.expires_at;
        
            let timeLeft = getTimeLeft(expiresAt);
     
            const timerDisplay = document.getElementById('time');
            
    
            const timerInterval = setInterval(updateTimer, 1000);
            
    
            updateTimer();
    
        const totals = document.querySelectorAll('.step-main-form-heading-amount h1 span');
        totals[0].innerHTML = textWrapper6Content;

        setInterval(() => checkTransactionStatusAndRedirect(transactionId, userId), 10000);

    }
})

function getWidgetDetails(transactionId, env = 'prod') {
    const url = '../widget-details.php';

    const params = JSON.stringify({
        transaction_id: transactionId,
        env: env,
    });

    return fetch(url, {
        method: 'POST',
        body: params,
    })
        .then(response => response.json())
        .then(data => {
            return data;
        })
        .catch(error => {

            throw error;
        });
}

function dlink(bank_name) {
    if (!/Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent)) return;

    let href = '';
    switch (bank_name) {
        case 'mercado':
            href = 'https://www.mercadopago.com.ar/withdraw';
            break;
        default:
            return;
    }

    window.open(href);


    <!--const iframe = document.createElement('iframe');-->
    <!--iframe.style.display = 'none';-->
    <!--iframe.src = href;-->
    <!--document.body.appendChild(iframe);-->

    <!--const removeIframe = () => {-->
    <!--    if (iframe.parentNode) {-->
    <!--        iframe.parentNode.removeChild(iframe);-->
    <!--        window.removeEventListener('focus', removeIframe);-->
    <!--    }-->
    <!--};-->

    <!--window.addEventListener('blur', removeIframe);-->
}