<?php
// Disable HTTP caching
header("Expires: Thu, 19 Nov 1969 08:52:00 GMT"); // Past date
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false); // HTTP/1.1 (IE-specific)
header("Pragma: no-cache"); // HTTP/1.0

require_once __DIR__ . '/constants.php';

ini_set('display_errors', 0); ini_set('display_startup_errors', 0); error_reporting(0);

function getFullUrl($relativePath) {
    // Detect protocol (http or https)
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';

    // Get host name (e.g., yourdomain.com)
    $host = $_SERVER['HTTP_HOST'];

    // Get current script directory (e.g., /app/api/)
    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);

    // Normalize the relative path
    $fullPath = $protocol . '://' . $host . $scriptDir . '/' . ltrim($relativePath, '/');

    return $fullPath;
}

function getWidgetDetails($transactionId, $env = 'prod') {
    $url = getFullUrl('../widget-details.php');

    $params = json_encode([
        'transaction_id' => $transactionId,
        'env' => $env,
    ]);

    $ch = curl_init($url);

    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $params,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($params),
        ],
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception('Request Error: ' . curl_error($ch));
    }

    curl_close($ch);

    $data = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('JSON Decode Error: ' . json_last_error_msg());
    }

    return $data;
}

$getWidgetDetails = getWidgetDetails($_GET['transaction_id']);
$isDebugOn = $_GET['debug'];

?><!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Pago</title>
    
    <link rel="stylesheet" href="./styles/steps.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:ital,opsz,wght@0,6..12,200..1000;1,6..12,200..1000&display=swap" rel="stylesheet">
    <script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "qnvl8se35c");
</script>
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-TC4M04VYHW"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
 
  gtag('config', 'G-TC4M04VYHW');
</script>
</head>
<body class="without-logo">
<div id="page-loader-container" class="step-main-form-container-loader">
    <div class="step-info-section-loader"></div>
    <div class="step-main-form-loader"></div>
</div>
<?php if($isDebugOn === 'on' || ($getWidgetDetails['status'] === 'PENDING' || $getWidgetDetails['status'] === 'PROCESSING')):?>
<div class="step-main-container" id="page-main-form">
    <div class="step-main-form-container">
        <div class="payment-container" id="step-main-form">
  <div class="progress-bar-container">
    <div class="progress-bar">
      <div class="progress-dot active"></div>
      <div class="progress-line"></div>
      <div class="progress-dot"></div>
      <div class="progress-line"></div>
      <div class="progress-dot"></div>
    </div>
  </div>

  <div class="payment-box">
      <div  class="payment-box-wrapper">
          <p class="warning hidden">
              ¡Atención! Por favor, indicar en el comentario de la transferencia únicamente la palabra  <strong>PAGO DE SERVICIOS</strong>, de lo contrario su pago no se procesará
  </p>
      <p class="amount-label" style="
    padding: 14px 0;
">Realizar el pago móvil de</p>
    <div class="step-main-form-heading-amount-container">
                            <div class="step-main-form-heading-amount">
                                <h1 style="
    color: black;
"><span id="client-amount-value"><?php echo sprintf('%.2f', (float)$getWidgetDetails['amount']);?></span> VES</h1>
                                
                            </div>
                        </div>
                        <p class="amount-subtitle" style="
    padding-bottom: 14px;
">(RECUERDA QUE DEBES TRANSFERIR EL MONTO EXACTO)</p>
          <div class="payment-name-code-container">
              <div class="payment-bank-container" id="payment-bank-container">
    <h2>Nombre del beneficiario:</h2>
    <div class="client-bank-container">
    <h1 id="recipient-bank" ><?php echo $getWidgetDetails['send_id']?></h1>
    </div>
    </div>
              <div class="payment-bank-container" id="payment-bank-container">
    <h2>Banco del beneficiario:</h2>
    <div class="client-bank-container">
    <h1 id="recipient-bank" ><?php echo $getWidgetDetails['operator_bank_title']?></h1>
    <div class="copy-client-bank hidden">
                                            <div class="copy-done" style="display: none;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="white"></rect>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="#24325A" stroke-width="2" stroke-linecap="round"></path>
                                                </svg>
                                            </div>
                                            <div class="copy" style="display: flex;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="white"></path>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="white"></path>
                                                </svg>
                                            </div>
                                        </div>
    </div>
    </div>
              <div class="payment-code-container" id="payment-code-container" style="
        margin: 10px 0;
">
    <p class="code-label">RIF:</p>
    <div class="pocket-address-input">
    <p id="payment-id" class="payment-code"><?php echo htmlspecialchars($getWidgetDetails['iban'] ?? ''); ?></p><div class="copy-address">
                                            <div class="copy-done" style="display: none;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="white"></rect>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="#24325A" stroke-width="2" stroke-linecap="round"></path>
                                                </svg>
                                            </div>
                                            <div class="copy" style="display: flex;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="white"></path>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="white"></path>
                                                </svg>
                                            </div>
                                        </div>
                                        </div>
                                        </div>
          <div class="payment-name-container" id="payment-name-container">
    <h2>Número de Teléfono:</h2>
    <div class="client-name-container">
    <h1 id="recipient-name" ><?php echo $getWidgetDetails['pocket_address']?></h1>
    <div class="copy-client-name">
                                            <div class="copy-done" style="display: none;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="white"></rect>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="#24325A" stroke-width="2" stroke-linecap="round"></path>
                                                </svg>
                                            </div>
                                            <div class="copy" style="display: flex;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="white"></path>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="white"></path>
                                                </svg>
                                            </div>
                                        </div>
    </div>
    </div>
    
                                        
                                        </div>
                                        <a href="#" onclick="openBDV(); return false;" style="
    background: #efedee;
    color: white;
    cursor: pointer;
    font-weight: 300;
    border-radius: 10px;
    padding: 8px;
    margin: 10px 0;
    display: block;
"> 
  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="100px" height="17px" viewBox="0 0 101 17" version="1.1" style="
">
<g id="surface1">
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 18.171875 1.753906 C 19.289062 1.738281 20.40625 1.730469 21.519531 1.722656 C 21.898438 1.722656 22.277344 1.71875 22.65625 1.714844 C 23.207031 1.707031 23.753906 1.703125 24.300781 1.703125 C 24.46875 1.699219 24.632812 1.695312 24.808594 1.691406 C 26.09375 1.691406 27.1875 1.902344 28.285156 2.597656 C 29.066406 3.398438 29.21875 4.066406 29.246094 5.171875 C 29.226562 6.027344 29.179688 6.65625 28.65625 7.359375 C 28.1875 7.777344 28.1875 7.777344 27.785156 8.0625 C 27.875 8.121094 27.96875 8.175781 28.066406 8.238281 C 29.046875 8.898438 29.597656 9.523438 29.878906 10.691406 C 30.042969 11.984375 29.984375 13.132812 29.183594 14.195312 C 28.109375 15.390625 26.890625 15.757812 25.335938 15.949219 C 24.808594 15.972656 24.277344 15.976562 23.746094 15.976562 C 23.597656 15.976562 23.449219 15.980469 23.296875 15.980469 C 22.984375 15.980469 22.671875 15.980469 22.363281 15.980469 C 21.886719 15.980469 21.410156 15.984375 20.929688 15.988281 C 20.628906 15.988281 20.324219 15.988281 20.019531 15.988281 C 19.808594 15.992188 19.808594 15.992188 19.589844 15.992188 C 18.910156 15.988281 18.578125 15.984375 18 15.597656 C 17.945312 15.160156 17.929688 14.765625 17.9375 14.324219 C 17.9375 14.195312 17.933594 14.0625 17.933594 13.925781 C 17.933594 13.492188 17.9375 13.058594 17.941406 12.625 C 17.941406 12.324219 17.941406 12.023438 17.941406 11.71875 C 17.941406 11.089844 17.945312 10.457031 17.949219 9.824219 C 17.953125 9.015625 17.957031 8.203125 17.957031 7.390625 C 17.957031 6.769531 17.960938 6.148438 17.960938 5.527344 C 17.960938 5.226562 17.964844 4.925781 17.964844 4.628906 C 17.964844 4.210938 17.96875 3.792969 17.96875 3.375 C 17.96875 3.25 17.96875 3.128906 17.972656 3 C 17.976562 2.144531 17.976562 2.144531 18.171875 1.753906 Z M 21.316406 4.382812 C 21.3125 4.84375 21.308594 5.308594 21.308594 5.773438 C 21.304688 5.90625 21.304688 6.035156 21.304688 6.171875 C 21.300781 6.511719 21.308594 6.847656 21.316406 7.1875 C 21.71875 7.585938 22.660156 7.402344 23.195312 7.40625 C 23.433594 7.410156 23.433594 7.410156 23.675781 7.414062 C 24.542969 7.421875 25.167969 7.417969 25.863281 6.835938 C 26.140625 6.273438 26.144531 5.691406 26.035156 5.082031 C 25.5 4.484375 25.0625 4.320312 24.289062 4.207031 C 23.839844 4.191406 23.394531 4.183594 22.945312 4.183594 C 22.769531 4.183594 22.769531 4.183594 22.585938 4.183594 C 21.929688 4.175781 21.929688 4.175781 21.316406 4.382812 Z M 21.316406 9.8125 C 21.300781 10.058594 21.296875 10.308594 21.296875 10.554688 C 21.292969 10.703125 21.292969 10.851562 21.292969 11.003906 C 21.296875 11.160156 21.296875 11.316406 21.296875 11.480469 C 21.296875 11.636719 21.296875 11.792969 21.292969 11.953125 C 21.292969 12.101562 21.292969 12.25 21.296875 12.40625 C 21.296875 12.542969 21.296875 12.679688 21.296875 12.820312 C 21.285156 13.148438 21.285156 13.148438 21.492188 13.320312 C 22.085938 13.367188 22.679688 13.359375 23.273438 13.363281 C 23.4375 13.367188 23.605469 13.371094 23.773438 13.375 C 24.722656 13.378906 25.394531 13.332031 26.210938 12.792969 C 26.679688 12.324219 26.699219 12.050781 26.734375 11.390625 C 26.535156 10.691406 26.390625 10.289062 25.785156 9.867188 C 24.933594 9.554688 24.171875 9.574219 23.273438 9.59375 C 23.105469 9.597656 22.9375 9.597656 22.761719 9.597656 C 21.980469 9.535156 21.980469 9.535156 21.316406 9.8125 Z M 21.316406 9.8125 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 32.660156 1.710938 C 32.816406 1.710938 32.976562 1.707031 33.136719 1.707031 C 33.472656 1.703125 33.8125 1.703125 34.148438 1.699219 C 34.65625 1.699219 35.164062 1.691406 35.671875 1.683594 C 37.976562 1.664062 40.03125 1.796875 41.761719 3.503906 C 43.402344 5.417969 43.503906 7.6875 43.371094 10.101562 C 43.214844 11.859375 42.554688 13.3125 41.257812 14.496094 C 39.65625 15.785156 37.929688 15.976562 35.933594 15.972656 C 35.800781 15.972656 35.667969 15.972656 35.53125 15.972656 C 35.25 15.972656 34.972656 15.972656 34.695312 15.972656 C 34.269531 15.96875 33.839844 15.972656 33.414062 15.972656 C 33.144531 15.972656 32.871094 15.972656 32.601562 15.972656 C 32.472656 15.972656 32.347656 15.972656 32.214844 15.972656 C 31.320312 15.96875 31.320312 15.96875 30.929688 15.773438 C 30.925781 13.972656 30.921875 12.167969 30.921875 10.367188 C 30.917969 9.53125 30.917969 8.691406 30.914062 7.855469 C 30.914062 7.050781 30.914062 6.242188 30.914062 5.4375 C 30.914062 5.128906 30.910156 4.820312 30.910156 4.511719 C 30.910156 4.078125 30.910156 3.648438 30.910156 3.21875 C 30.910156 3.089844 30.90625 2.960938 30.90625 2.828125 C 30.910156 1.46875 31.460938 1.722656 32.660156 1.710938 Z M 34.074219 4.730469 C 34.058594 4.988281 34.050781 5.246094 34.050781 5.503906 C 34.050781 5.667969 34.050781 5.832031 34.050781 6.003906 C 34.050781 6.183594 34.050781 6.359375 34.050781 6.542969 C 34.050781 6.726562 34.050781 6.910156 34.050781 7.097656 C 34.050781 7.484375 34.050781 7.867188 34.050781 8.253906 C 34.050781 8.847656 34.050781 9.441406 34.050781 10.035156 C 34.050781 10.410156 34.050781 10.78125 34.050781 11.15625 C 34.050781 11.335938 34.050781 11.515625 34.050781 11.699219 C 34.050781 11.863281 34.050781 12.027344 34.050781 12.195312 C 34.050781 12.339844 34.050781 12.488281 34.050781 12.636719 C 34.039062 12.972656 34.039062 12.972656 34.25 13.144531 C 36.734375 13.355469 36.734375 13.355469 38.96875 12.441406 C 39.960938 11.484375 40.136719 10.296875 40.246094 8.972656 C 40.210938 7.8125 39.9375 6.617188 39.371094 5.609375 C 38.277344 4.660156 37.25 4.453125 35.832031 4.5 C 35.605469 4.503906 35.605469 4.503906 35.375 4.507812 C 34.667969 4.453125 34.667969 4.453125 34.074219 4.730469 Z M 34.074219 4.730469 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 45.410156 1.6875 C 45.601562 1.675781 45.601562 1.675781 45.800781 1.667969 C 46.171875 1.660156 46.171875 1.660156 46.832031 1.753906 C 47.472656 2.539062 47.6875 3.601562 47.980469 4.554688 C 48.035156 4.738281 48.09375 4.925781 48.152344 5.117188 C 48.335938 5.707031 48.515625 6.296875 48.699219 6.890625 C 48.820312 7.292969 48.945312 7.691406 49.070312 8.09375 C 49.371094 9.074219 49.675781 10.058594 49.976562 11.042969 C 50.023438 10.894531 50.070312 10.75 50.117188 10.601562 C 51.683594 5.710938 51.683594 5.710938 52.433594 3.4375 C 52.484375 3.285156 52.53125 3.132812 52.585938 2.976562 C 52.925781 1.949219 52.925781 1.949219 53.121094 1.753906 C 53.585938 1.730469 54.042969 1.71875 54.507812 1.71875 C 54.703125 1.714844 54.703125 1.714844 54.902344 1.714844 C 55.238281 1.710938 55.578125 1.730469 55.917969 1.753906 C 56.089844 1.925781 56.089844 1.925781 56.265625 2.101562 C 56.042969 3.558594 55.523438 4.945312 55.058594 6.339844 C 54.976562 6.59375 54.890625 6.851562 54.808594 7.105469 C 54.628906 7.636719 54.453125 8.171875 54.277344 8.703125 C 54.050781 9.382812 53.824219 10.066406 53.601562 10.746094 C 53.429688 11.273438 53.253906 11.800781 53.078125 12.324219 C 52.996094 12.578125 52.910156 12.828125 52.828125 13.078125 C 52.714844 13.429688 52.597656 13.78125 52.480469 14.132812 C 52.414062 14.332031 52.347656 14.53125 52.277344 14.734375 C 52.085938 15.21875 51.894531 15.5625 51.546875 15.949219 C 51.207031 16.039062 51.207031 16.039062 50.828125 16.042969 C 50.691406 16.042969 50.550781 16.042969 50.410156 16.042969 C 50.265625 16.042969 50.125 16.039062 49.976562 16.035156 C 49.832031 16.039062 49.6875 16.042969 49.542969 16.042969 C 49.402344 16.042969 49.265625 16.042969 49.125 16.042969 C 49 16.039062 48.871094 16.039062 48.742188 16.039062 C 48.253906 15.910156 48.152344 15.667969 47.878906 15.246094 C 47.742188 14.90625 47.621094 14.5625 47.507812 14.214844 C 47.4375 14.007812 47.371094 13.796875 47.300781 13.582031 C 47.226562 13.355469 47.15625 13.128906 47.082031 12.902344 C 47.003906 12.667969 46.929688 12.433594 46.851562 12.199219 C 46.652344 11.582031 46.453125 10.964844 46.253906 10.34375 C 46.09375 9.84375 45.929688 9.347656 45.765625 8.847656 C 45.300781 7.417969 44.839844 5.988281 44.382812 4.558594 C 44.328125 4.386719 44.273438 4.21875 44.21875 4.042969 C 44.171875 3.890625 44.121094 3.738281 44.070312 3.578125 C 44.03125 3.449219 43.988281 3.320312 43.945312 3.1875 C 43.847656 2.753906 43.832031 2.371094 43.859375 1.929688 C 44.21875 1.566406 44.917969 1.695312 45.410156 1.6875 Z M 45.410156 1.6875 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(99.215686%,78.431374%,0%);fill-opacity:1;" d="M 6.617188 0.25 C 7.390625 0.640625 7.644531 1.179688 8.039062 1.929688 C 8.144531 2.113281 8.253906 2.296875 8.367188 2.488281 C 8.660156 3.226562 8.398438 3.808594 8.203125 4.554688 C 7.171875 8.503906 6.808594 12.59375 6.464844 16.648438 C 5.941406 16.472656 5.941406 16.472656 5.722656 16.140625 C 5.652344 15.996094 5.578125 15.847656 5.503906 15.695312 C 5.421875 15.53125 5.339844 15.367188 5.257812 15.195312 C 5.167969 15.011719 5.082031 14.832031 4.988281 14.644531 C 4.851562 14.363281 4.851562 14.363281 4.710938 14.078125 C 4.410156 13.476562 4.117188 12.871094 3.824219 12.269531 C 3.53125 11.675781 3.242188 11.085938 2.949219 10.492188 C 2.757812 10.109375 2.570312 9.722656 2.378906 9.335938 C 1.960938 8.484375 1.539062 7.636719 1.082031 6.804688 C 0.96875 6.601562 0.96875 6.601562 0.855469 6.394531 C 0.722656 6.152344 0.585938 5.90625 0.445312 5.667969 C 0.03125 4.917969 -0.125 4.359375 0 3.503906 C 0.46875 2.851562 1.109375 2.558594 1.820312 2.207031 C 1.925781 2.152344 2.03125 2.097656 2.140625 2.042969 C 2.480469 1.875 2.816406 1.710938 3.15625 1.542969 C 3.382812 1.429688 3.613281 1.316406 3.839844 1.203125 C 5.960938 0.152344 5.960938 0.152344 6.617188 0.25 Z M 6.617188 0.25 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(0%,40.392157%,69.411767%);fill-opacity:1;" d="M 8.5625 3.679688 C 9.007812 4.082031 9.261719 4.484375 9.53125 5.019531 C 9.613281 5.1875 9.699219 5.351562 9.785156 5.519531 C 9.875 5.699219 9.964844 5.878906 10.054688 6.0625 C 10.148438 6.246094 10.238281 6.429688 10.335938 6.617188 C 10.53125 7.003906 10.722656 7.394531 10.917969 7.78125 C 11.214844 8.375 11.515625 8.96875 11.816406 9.5625 C 12.003906 9.9375 12.191406 10.316406 12.382812 10.695312 C 12.472656 10.871094 12.5625 11.046875 12.65625 11.230469 C 12.738281 11.398438 12.820312 11.5625 12.902344 11.734375 C 13.011719 11.953125 13.011719 11.953125 13.125 12.175781 C 13.3125 12.707031 13.332031 13.113281 13.28125 13.671875 C 12.410156 14.644531 11.140625 15.148438 9.992188 15.730469 C 9.59375 15.933594 9.195312 16.136719 8.800781 16.339844 C 8.625 16.429688 8.449219 16.519531 8.265625 16.609375 C 7.882812 16.789062 7.882812 16.789062 7.6875 17 C 7.339844 17.007812 6.988281 17.007812 6.640625 17 C 6.921875 5.324219 6.921875 5.324219 8.5625 3.679688 Z M 8.5625 3.679688 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(84.705883%,5.490196%,23.529412%);fill-opacity:1;" d="M 15.042969 0.0273438 C 15.378906 0.175781 15.378906 0.175781 15.597656 0.46875 C 16.257812 2.53125 15.238281 5.597656 14.886719 7.652344 C 14.777344 8.296875 14.667969 8.945312 14.558594 9.589844 C 14.492188 10 14.421875 10.410156 14.351562 10.820312 C 14.320312 11.011719 14.289062 11.207031 14.253906 11.40625 C 14.222656 11.582031 14.191406 11.761719 14.160156 11.941406 C 14.132812 12.097656 14.105469 12.253906 14.078125 12.417969 C 13.980469 12.792969 13.980469 12.792969 13.628906 13.144531 C 13.53125 12.945312 13.429688 12.742188 13.328125 12.535156 C 12.953125 11.78125 12.578125 11.027344 12.203125 10.273438 C 12.042969 9.949219 11.882812 9.625 11.71875 9.300781 C 11.488281 8.832031 11.253906 8.359375 11.019531 7.890625 C 10.941406 7.738281 10.867188 7.585938 10.789062 7.429688 C 10.449219 6.75 10.109375 6.078125 9.742188 5.417969 C 9.683594 5.308594 9.625 5.203125 9.5625 5.097656 C 9.410156 4.820312 9.253906 4.550781 9.097656 4.277344 C 8.910156 3.855469 8.910156 3.855469 9.085938 3.328125 C 9.46875 3.039062 9.46875 3.039062 9.972656 2.726562 C 10.152344 2.613281 10.335938 2.5 10.523438 2.382812 C 10.714844 2.265625 10.910156 2.148438 11.105469 2.027344 C 11.292969 1.910156 11.480469 1.792969 11.675781 1.671875 C 14.40625 -0.0195312 14.40625 -0.0195312 15.042969 0.0273438 Z M 15.042969 0.0273438 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 64.128906 9.289062 C 64.550781 9.316406 64.550781 9.316406 65.003906 9.464844 C 65.246094 9.804688 65.246094 9.804688 65.433594 10.246094 C 65.5 10.40625 65.570312 10.5625 65.640625 10.726562 C 65.707031 10.890625 65.773438 11.058594 65.84375 11.226562 C 65.914062 11.394531 65.988281 11.558594 66.058594 11.730469 C 66.234375 12.144531 66.40625 12.554688 66.574219 12.96875 C 66.9375 12.605469 67.046875 12.371094 67.234375 11.902344 C 67.292969 11.761719 67.351562 11.621094 67.410156 11.476562 C 67.53125 11.179688 67.648438 10.882812 67.765625 10.582031 C 68.21875 9.507812 68.21875 9.507812 68.796875 9.265625 C 69.195312 9.289062 69.195312 9.289062 69.371094 9.464844 C 69.332031 10.710938 68.757812 11.75 68.234375 12.859375 C 68.101562 13.148438 68.101562 13.148438 67.964844 13.445312 C 67.304688 14.867188 67.304688 14.867188 67.101562 15.070312 C 66.695312 15.148438 66.695312 15.148438 66.226562 15.070312 C 65.535156 14.195312 65.132812 13.191406 64.699219 12.167969 C 64.625 12.007812 64.554688 11.84375 64.480469 11.675781 C 64.414062 11.515625 64.34375 11.355469 64.273438 11.195312 C 64.214844 11.050781 64.152344 10.90625 64.089844 10.761719 C 63.941406 10.300781 63.917969 9.941406 63.953125 9.464844 C 64.011719 9.40625 64.070312 9.347656 64.128906 9.289062 Z M 64.128906 9.289062 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 100.125 11.042969 C 100.585938 11.347656 100.753906 11.523438 100.925781 12.042969 C 101.023438 12.570312 101.023438 13.070312 101.023438 13.605469 C 101.023438 13.90625 101.023438 13.90625 101.023438 14.214844 C 101 14.722656 101 14.722656 100.824219 15.070312 C 100.417969 15.070312 100.011719 15.070312 99.601562 15.070312 C 99.410156 15.113281 99.21875 15.152344 99.023438 15.191406 C 98.300781 15.253906 98.070312 15.15625 97.503906 14.722656 C 97.332031 14.546875 97.332031 14.546875 97.3125 14.222656 C 97.320312 13.863281 97.324219 13.503906 97.332031 13.144531 C 98.207031 12.617188 98.785156 12.566406 99.777344 12.617188 C 99.71875 12.445312 99.660156 12.273438 99.601562 12.09375 C 98.96875 12.152344 98.332031 12.207031 97.679688 12.269531 C 97.621094 11.980469 97.566406 11.691406 97.503906 11.390625 C 98.335938 10.898438 99.1875 10.925781 100.125 11.042969 Z M 98.378906 13.671875 C 98.496094 13.902344 98.609375 14.132812 98.726562 14.371094 C 99.167969 14.246094 99.167969 14.246094 99.601562 14.019531 C 99.757812 13.664062 99.757812 13.664062 99.777344 13.320312 C 99.117188 13.320312 98.917969 13.359375 98.378906 13.671875 Z M 98.378906 13.671875 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 93.3125 11.042969 C 93.804688 11.425781 94.082031 11.710938 94.359375 12.269531 C 94.359375 12.613281 94.359375 12.960938 94.359375 13.320312 C 93.496094 13.378906 92.628906 13.433594 91.738281 13.496094 C 91.910156 13.753906 91.910156 13.753906 92.089844 14.019531 C 92.59375 14.085938 92.59375 14.085938 93.160156 14.054688 C 93.351562 14.046875 93.542969 14.042969 93.738281 14.039062 C 93.886719 14.03125 94.035156 14.027344 94.183594 14.019531 C 94.183594 14.253906 94.183594 14.484375 94.183594 14.722656 C 93.710938 15.199219 93.335938 15.195312 92.679688 15.253906 C 92.007812 15.242188 91.621094 15.058594 91.039062 14.722656 C 90.433594 14.0625 90.4375 13.554688 90.464844 12.691406 C 90.53125 12.144531 90.6875 11.8125 91.039062 11.390625 C 91.777344 10.898438 92.445312 10.902344 93.3125 11.042969 Z M 92.089844 11.917969 C 91.972656 12.148438 91.859375 12.378906 91.738281 12.617188 C 92.257812 12.617188 92.777344 12.617188 93.3125 12.617188 C 93.195312 12.386719 93.082031 12.15625 92.960938 11.917969 C 92.671875 11.917969 92.386719 11.917969 92.089844 11.917969 Z M 92.089844 11.917969 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 71.992188 11.042969 C 72.488281 11.425781 72.765625 11.710938 73.042969 12.269531 C 73.042969 12.613281 73.042969 12.960938 73.042969 13.320312 C 72.175781 13.378906 71.3125 13.433594 70.421875 13.496094 C 70.59375 13.753906 70.59375 13.753906 70.769531 14.019531 C 71.277344 14.085938 71.277344 14.085938 71.839844 14.054688 C 72.03125 14.046875 72.222656 14.042969 72.421875 14.039062 C 72.566406 14.03125 72.714844 14.027344 72.867188 14.019531 C 72.867188 14.253906 72.867188 14.484375 72.867188 14.722656 C 72.390625 15.199219 72.015625 15.195312 71.363281 15.253906 C 70.691406 15.242188 70.304688 15.058594 69.722656 14.722656 C 69.113281 14.0625 69.121094 13.554688 69.144531 12.691406 C 69.210938 12.144531 69.367188 11.8125 69.722656 11.390625 C 70.460938 10.898438 71.125 10.902344 71.992188 11.042969 Z M 70.769531 11.917969 C 70.511719 12.265625 70.511719 12.265625 70.246094 12.617188 C 70.824219 12.617188 71.398438 12.617188 71.992188 12.617188 C 71.878906 12.386719 71.761719 12.15625 71.644531 11.917969 C 71.230469 11.859375 71.230469 11.859375 70.769531 11.917969 Z M 70.769531 11.917969 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 73.742188 11.042969 C 74.027344 11.042969 74.316406 11.042969 74.613281 11.042969 C 74.613281 11.15625 74.613281 11.273438 74.613281 11.390625 C 74.789062 11.277344 74.960938 11.160156 75.136719 11.042969 C 75.515625 10.988281 75.515625 10.988281 75.925781 10.988281 C 76.058594 10.984375 76.195312 10.980469 76.335938 10.976562 C 76.800781 11.054688 76.945312 11.203125 77.234375 11.566406 C 77.523438 12.144531 77.433594 12.785156 77.433594 13.417969 C 77.433594 13.625 77.433594 13.625 77.433594 13.839844 C 77.433594 14.875 77.433594 14.875 77.234375 15.070312 C 76.945312 15.078125 76.652344 15.078125 76.363281 15.070312 C 76.101562 14.554688 76.125 14.050781 76.089844 13.472656 C 76.074219 13.25 76.058594 13.023438 76.042969 12.792969 C 76.035156 12.621094 76.023438 12.445312 76.011719 12.269531 C 75.679688 12.148438 75.679688 12.148438 75.3125 12.09375 C 74.816406 12.59375 74.898438 12.984375 74.867188 13.679688 C 74.804688 14.878906 74.804688 14.878906 74.613281 15.070312 C 74.324219 15.078125 74.03125 15.078125 73.742188 15.070312 C 73.539062 14.664062 73.542969 14.425781 73.542969 13.972656 C 73.542969 13.824219 73.542969 13.675781 73.542969 13.523438 C 73.542969 13.371094 73.542969 13.214844 73.542969 13.058594 C 73.542969 12.902344 73.542969 12.75 73.542969 12.589844 C 73.542969 12.441406 73.542969 12.292969 73.542969 12.140625 C 73.542969 12.007812 73.542969 11.871094 73.542969 11.730469 C 73.566406 11.390625 73.566406 11.390625 73.742188 11.042969 Z M 73.742188 11.042969 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 80.90625 11.042969 C 81.449219 11.390625 81.449219 11.390625 81.777344 11.917969 C 81.847656 12.410156 81.820312 12.820312 81.777344 13.320312 C 80.914062 13.320312 80.046875 13.320312 79.15625 13.320312 C 79.214844 13.550781 79.273438 13.78125 79.332031 14.019531 C 80.140625 14.019531 80.945312 14.019531 81.777344 14.019531 C 81.722656 14.308594 81.664062 14.597656 81.605469 14.898438 C 80.738281 15.265625 80.050781 15.339844 79.15625 15.070312 C 78.570312 14.730469 78.203125 14.484375 77.988281 13.824219 C 77.847656 12.933594 77.933594 12.328125 78.457031 11.566406 C 79.207031 10.886719 79.933594 10.878906 80.90625 11.042969 Z M 79.507812 11.917969 C 79.390625 12.148438 79.277344 12.378906 79.15625 12.617188 C 79.734375 12.617188 80.3125 12.617188 80.90625 12.617188 C 80.789062 12.386719 80.675781 12.15625 80.554688 11.917969 C 80.210938 11.917969 79.863281 11.917969 79.507812 11.917969 Z M 79.507812 11.917969 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 86.769531 11.03125 C 86.980469 11.035156 86.980469 11.035156 87.195312 11.042969 C 87.207031 11.226562 87.214844 11.414062 87.226562 11.605469 C 87.242188 11.847656 87.257812 12.089844 87.273438 12.332031 C 87.277344 12.457031 87.285156 12.578125 87.292969 12.703125 C 87.324219 13.386719 87.324219 13.386719 87.546875 14.019531 C 87.832031 13.960938 88.121094 13.90625 88.417969 13.84375 C 88.429688 13.6875 88.441406 13.527344 88.449219 13.367188 C 88.464844 13.160156 88.480469 12.953125 88.496094 12.738281 C 88.507812 12.535156 88.523438 12.328125 88.539062 12.117188 C 88.59375 11.566406 88.59375 11.566406 88.769531 11.042969 C 89.058594 11.035156 89.351562 11.035156 89.640625 11.042969 C 89.816406 11.214844 89.816406 11.214844 89.835938 11.589844 C 89.835938 11.75 89.835938 11.910156 89.832031 12.078125 C 89.832031 12.25 89.832031 12.421875 89.832031 12.601562 C 89.832031 12.785156 89.828125 12.96875 89.828125 13.15625 C 89.828125 13.339844 89.824219 13.523438 89.824219 13.710938 C 89.824219 14.164062 89.820312 14.617188 89.816406 15.070312 C 89.351562 15.070312 88.882812 15.070312 88.417969 15.070312 C 88.226562 15.113281 88.035156 15.152344 87.839844 15.191406 C 87.117188 15.253906 86.878906 15.167969 86.320312 14.722656 C 86.121094 14.320312 86.125 14.097656 86.125 13.652344 C 86.125 13.511719 86.125 13.371094 86.125 13.226562 C 86.125 13.082031 86.125 12.933594 86.125 12.78125 C 86.125 12.636719 86.125 12.488281 86.125 12.335938 C 86.125 11.046875 86.125 11.046875 86.769531 11.03125 Z M 86.769531 11.03125 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 64.480469 2.277344 C 66.925781 2.277344 66.925781 2.277344 67.800781 2.628906 C 68.039062 2.925781 68.039062 2.925781 68.148438 3.328125 C 68.082031 3.953125 68.082031 3.953125 67.972656 4.558594 C 67.933594 5.070312 67.933594 5.070312 68.148438 5.433594 C 68.230469 6.714844 68.230469 6.714844 67.917969 7.175781 C 66.828125 7.863281 65.914062 7.535156 64.480469 7.535156 C 64.480469 5.800781 64.480469 4.066406 64.480469 2.277344 Z M 65.003906 2.804688 C 65.003906 3.382812 65.003906 3.960938 65.003906 4.558594 C 65.3125 4.570312 65.621094 4.582031 65.933594 4.589844 C 66.105469 4.59375 66.277344 4.601562 66.453125 4.609375 C 66.929688 4.597656 66.929688 4.597656 67.25 4.320312 C 67.492188 4.027344 67.492188 4.027344 67.4375 3.582031 C 67.316406 3.140625 67.316406 3.140625 66.96875 2.953125 C 66.3125 2.703125 65.699219 2.785156 65.003906 2.804688 Z M 65.003906 5.082031 C 65.003906 5.71875 65.003906 6.355469 65.003906 7.011719 C 65.414062 7.019531 65.414062 7.019531 65.832031 7.03125 C 65.988281 7.035156 66.140625 7.039062 66.300781 7.042969 C 66.777344 7.007812 67.050781 6.925781 67.449219 6.660156 C 67.625 6.238281 67.625 6.238281 67.625 5.785156 C 67.34375 5.246094 67.34375 5.246094 66.957031 5.136719 C 66.546875 5.078125 66.160156 5.066406 65.746094 5.070312 C 65.5 5.074219 65.257812 5.078125 65.003906 5.082031 Z M 65.003906 5.082031 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 82.476562 11.042969 C 82.941406 11.035156 83.402344 11.03125 83.863281 11.03125 C 83.996094 11.027344 84.128906 11.027344 84.265625 11.027344 C 84.601562 11.023438 84.9375 11.03125 85.273438 11.042969 C 85.449219 11.214844 85.449219 11.214844 85.507812 11.601562 C 85.425781 12.285156 85.109375 12.59375 84.660156 13.113281 C 84.441406 13.367188 84.441406 13.367188 84.21875 13.628906 C 84.105469 13.757812 83.992188 13.886719 83.875 14.019531 C 84.453125 14.078125 85.027344 14.136719 85.621094 14.195312 C 85.621094 14.484375 85.621094 14.773438 85.621094 15.070312 C 84.527344 15.070312 83.429688 15.070312 82.304688 15.070312 C 82.304688 14.074219 82.578125 13.730469 83.175781 13 C 83.261719 12.898438 83.34375 12.792969 83.429688 12.683594 C 83.632812 12.425781 83.84375 12.171875 84.050781 11.917969 C 83.472656 11.917969 82.898438 11.917969 82.304688 11.917969 C 82.359375 11.628906 82.417969 11.339844 82.476562 11.042969 Z M 82.476562 11.042969 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 95.234375 9.289062 C 95.851562 9.382812 95.851562 9.382812 96.105469 9.640625 C 96.136719 9.964844 96.152344 10.289062 96.164062 10.613281 C 96.167969 10.8125 96.175781 11.007812 96.183594 11.210938 C 96.191406 11.417969 96.199219 11.628906 96.207031 11.839844 C 96.214844 12.050781 96.21875 12.257812 96.226562 12.472656 C 96.246094 12.988281 96.265625 13.503906 96.28125 14.019531 C 96.570312 14.078125 96.859375 14.136719 97.15625 14.195312 C 97.097656 14.484375 97.039062 14.773438 96.980469 15.070312 C 96.050781 15.285156 96.050781 15.285156 95.539062 15.125 C 95.160156 14.84375 95.058594 14.636719 94.882812 14.195312 C 94.839844 13.703125 94.839844 13.703125 94.835938 13.144531 C 94.835938 12.941406 94.835938 12.738281 94.835938 12.53125 C 94.835938 12.320312 94.839844 12.113281 94.839844 11.894531 C 94.839844 11.683594 94.835938 11.472656 94.835938 11.253906 C 94.835938 11.054688 94.835938 10.851562 94.835938 10.644531 C 94.839844 10.460938 94.839844 10.277344 94.839844 10.085938 C 94.882812 9.640625 94.882812 9.640625 95.234375 9.289062 Z M 95.234375 9.289062 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 88.070312 2.277344 C 88.242188 2.277344 88.414062 2.277344 88.59375 2.277344 C 88.59375 4.011719 88.59375 5.75 88.59375 7.535156 C 88.363281 7.476562 88.132812 7.421875 87.894531 7.359375 C 87.777344 7.417969 87.664062 7.476562 87.546875 7.535156 C 86.820312 7.605469 86.441406 7.613281 85.820312 7.21875 C 85.335938 6.71875 85.28125 6.40625 85.230469 5.71875 C 85.289062 4.875 85.5625 4.445312 86.148438 3.855469 C 86.476562 3.816406 86.476562 3.816406 86.847656 3.824219 C 87.03125 3.824219 87.03125 3.824219 87.21875 3.828125 C 87.546875 3.855469 87.546875 3.855469 87.894531 4.03125 C 87.953125 3.453125 88.011719 2.875 88.070312 2.277344 Z M 86.179688 4.65625 C 85.890625 5.246094 85.890625 5.660156 85.972656 6.308594 C 86.226562 6.769531 86.226562 6.769531 86.671875 7.011719 C 87.21875 7.039062 87.21875 7.039062 87.71875 6.835938 C 88.117188 6.386719 88.066406 6.113281 88.035156 5.507812 C 87.933594 4.929688 87.933594 4.929688 87.675781 4.566406 C 87.117188 4.226562 86.679688 4.222656 86.179688 4.65625 Z M 86.179688 4.65625 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 70.507812 3.800781 C 70.710938 3.792969 70.710938 3.792969 70.917969 3.78125 C 71.292969 3.855469 71.292969 3.855469 71.601562 4.113281 C 71.921875 4.769531 71.875 5.371094 71.851562 6.089844 C 71.847656 6.296875 71.847656 6.296875 71.84375 6.511719 C 71.835938 6.851562 71.828125 7.195312 71.816406 7.535156 C 71.710938 7.503906 71.601562 7.472656 71.492188 7.4375 C 71.113281 7.320312 71.113281 7.320312 70.769531 7.535156 C 70.089844 7.597656 69.691406 7.628906 69.109375 7.25 C 68.847656 6.835938 68.847656 6.835938 68.871094 6.289062 C 69.023438 5.785156 69.023438 5.785156 69.371094 5.433594 C 69.789062 5.398438 69.789062 5.398438 70.265625 5.410156 C 70.507812 5.414062 70.507812 5.414062 70.75 5.421875 C 70.871094 5.425781 70.992188 5.429688 71.121094 5.433594 C 71.0625 5.144531 71.003906 4.855469 70.945312 4.558594 C 70.328125 4.542969 69.789062 4.550781 69.195312 4.730469 C 69.195312 4.5 69.195312 4.269531 69.195312 4.03125 C 69.675781 3.871094 70.011719 3.816406 70.507812 3.800781 Z M 69.546875 6.132812 C 69.605469 6.367188 69.660156 6.597656 69.722656 6.835938 C 70.132812 6.96875 70.132812 6.96875 70.59375 7.011719 C 70.929688 6.820312 70.929688 6.820312 71.121094 6.484375 C 71.121094 6.253906 71.121094 6.023438 71.121094 5.785156 C 70.457031 5.785156 70.136719 5.871094 69.546875 6.132812 Z M 69.546875 6.132812 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 82.128906 3.855469 C 82.707031 4.316406 82.929688 4.574219 83.085938 5.292969 C 83.128906 5.984375 83.058594 6.527344 82.664062 7.109375 C 82.042969 7.605469 81.710938 7.695312 80.933594 7.636719 C 80.429688 7.503906 80.117188 7.25 79.824219 6.820312 C 79.511719 6.078125 79.539062 5.277344 79.828125 4.53125 C 80.359375 3.679688 81.234375 3.679688 82.128906 3.855469 Z M 80.597656 4.589844 C 80.316406 5 80.242188 5.285156 80.207031 5.785156 C 80.371094 6.328125 80.503906 6.609375 80.90625 7.011719 C 81.398438 7.074219 81.667969 7.085938 82.085938 6.800781 C 82.367188 6.390625 82.441406 6.105469 82.476562 5.609375 C 82.3125 5.066406 82.179688 4.785156 81.777344 4.382812 C 81.285156 4.316406 81.015625 4.304688 80.597656 4.589844 Z M 80.597656 4.589844 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 91.398438 3.769531 C 92.003906 3.921875 92.265625 4.230469 92.613281 4.730469 C 92.613281 5.078125 92.613281 5.425781 92.613281 5.785156 C 91.746094 5.785156 90.882812 5.785156 89.992188 5.785156 C 90.105469 6.074219 90.222656 6.363281 90.339844 6.660156 C 91.09375 6.792969 91.695312 6.863281 92.4375 6.660156 C 92.4375 6.832031 92.4375 7.007812 92.4375 7.1875 C 91.730469 7.65625 91.171875 7.671875 90.339844 7.535156 C 89.804688 7.21875 89.804688 7.21875 89.46875 6.660156 C 89.296875 5.71875 89.304688 4.992188 89.816406 4.171875 C 90.394531 3.824219 90.734375 3.726562 91.398438 3.769531 Z M 89.992188 5.082031 C 89.992188 5.199219 89.992188 5.3125 89.992188 5.433594 C 90.683594 5.433594 91.375 5.433594 92.089844 5.433594 C 91.835938 4.628906 91.835938 4.628906 91.5625 4.382812 C 90.777344 4.273438 90.480469 4.464844 89.992188 5.082031 Z M 89.992188 5.082031 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 73.980469 3.8125 C 74.183594 3.808594 74.386719 3.804688 74.597656 3.796875 C 75.136719 3.855469 75.136719 3.855469 75.460938 4.089844 C 75.914062 4.75 75.855469 5.390625 75.847656 6.167969 C 75.847656 6.390625 75.84375 6.613281 75.84375 6.84375 C 75.839844 7.011719 75.839844 7.183594 75.835938 7.359375 C 75.605469 7.417969 75.375 7.476562 75.136719 7.535156 C 75.128906 7.335938 75.117188 7.136719 75.105469 6.929688 C 75.089844 6.667969 75.078125 6.40625 75.0625 6.144531 C 75.054688 6.011719 75.046875 5.878906 75.042969 5.742188 C 75.0625 5.097656 75.0625 5.097656 74.789062 4.558594 C 74.359375 4.511719 74.359375 4.511719 73.914062 4.558594 C 73.414062 5.058594 73.496094 5.457031 73.457031 6.15625 C 73.4375 6.492188 73.4375 6.492188 73.417969 6.835938 C 73.410156 7.007812 73.398438 7.183594 73.390625 7.359375 C 73.160156 7.359375 72.929688 7.359375 72.691406 7.359375 C 72.6875 6.808594 72.683594 6.257812 72.679688 5.707031 C 72.679688 5.550781 72.679688 5.390625 72.675781 5.230469 C 72.675781 5.082031 72.675781 4.929688 72.675781 4.777344 C 72.671875 4.570312 72.671875 4.570312 72.671875 4.355469 C 72.71875 3.613281 73.378906 3.820312 73.980469 3.8125 Z M 73.980469 3.8125 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 60.109375 0.351562 C 60.167969 0.351562 60.226562 0.351562 60.285156 0.351562 C 60.285156 5.785156 60.285156 11.222656 60.285156 16.824219 C 60.171875 16.824219 60.054688 16.824219 59.9375 16.824219 C 59.933594 14.703125 59.929688 12.582031 59.925781 10.457031 C 59.925781 9.472656 59.925781 8.488281 59.921875 7.503906 C 59.921875 6.550781 59.917969 5.601562 59.917969 4.652344 C 59.917969 4.289062 59.917969 3.925781 59.917969 3.5625 C 59.917969 3.054688 59.917969 2.550781 59.917969 2.042969 C 59.914062 1.890625 59.914062 1.738281 59.914062 1.582031 C 59.917969 0.546875 59.917969 0.546875 60.109375 0.351562 Z M 60.109375 0.351562 "></path>
<path style=" stroke:none;fill-rule:nonzero;fill:rgb(21.568628%,21.568628%,21.176471%);fill-opacity:1;" d="M 78.984375 3.855469 C 79.332031 4.207031 79.332031 4.207031 79.332031 4.730469 C 79.226562 4.710938 79.117188 4.691406 79.007812 4.667969 C 78.152344 4.5 78.152344 4.5 77.386719 4.820312 C 77.175781 5.429688 77.261719 5.859375 77.410156 6.484375 C 77.726562 6.878906 77.726562 6.878906 78.175781 6.867188 C 78.585938 6.839844 78.941406 6.777344 79.332031 6.660156 C 79.265625 7 79.265625 7 79.15625 7.359375 C 78.597656 7.640625 78.015625 7.625 77.410156 7.535156 C 76.984375 7.207031 76.773438 6.960938 76.535156 6.484375 C 76.429688 5.609375 76.402344 4.945312 76.875 4.183594 C 77.574219 3.753906 78.179688 3.703125 78.984375 3.855469 Z M 78.984375 3.855469 "></path>
</g>
</svg>
</a>
<script>
  function openBDV() {
    var webFallback   = 'https://bdvenlinea.banvenez.com/';
    var playStoreUrl  = 'https://play.google.com/store/apps/details?id=com.bancodevenezuela.bdvdigital';
    var appStoreUrl   = 'https://apps.apple.com/app/bdvapp/id1629896484';

    var ua       = navigator.userAgent || navigator.vendor || window.opera;
    var isAndroid = /Android/i.test(ua);
    var isIOS     = /iPhone|iPad|iPod/i.test(ua);

    if (isAndroid) {
      // Android Chrome supports intent:// deep links
      var intentUrl =
        'intent://#Intent;' +
        'package=com.bancodevenezuela.bdvdigital;' +
        'scheme=bdv;' +
        'S.browser_fallback_url=' + encodeURIComponent(playStoreUrl) +
        ';end;';

      window.location.href = intentUrl;
      return;
    }

    if (isIOS) {
      // Safe option: go directly to App Store page for BDVapp
      window.location.href = appStoreUrl;
      return;

      // ADVANCED (ONLY if you confirm real scheme on a device):
      // Uncomment this block and replace 'bdvapp://pagomovil' with
      // the actual URL scheme if you discover it works.
      /*
      var appScheme = 'bdvapp://pagomovil'; // <-- NOT documented, just an example
      var opened = false;

      var timeout = setTimeout(function() {
        if (!opened) {
          // Probably app not installed → send to App Store
          window.location.href = appStoreUrl;
        }
      }, 1500);

      window.location.href = appScheme;

      window.addEventListener('pagehide', function () {
        opened = true;
        clearTimeout(timeout);
      });
      */
    }

    // Desktop or unknown device → open web banking
    window.open(webFallback, '_blank');
  }
</script>

    <div class="countdown hidden">
      <p>Tienes:</p>
      <div class="timer-container">
                        <div class="timer">
                            <div class="" id="time">Expired</div>
                        </div>
                    </div>
    </div>
    <?php if ($TEXTS['currency'] === 'ARS' || $TEXTS['currency'] === 'USD'): ?>
                                <div id="bank-list-container" data-link="pichincha" class="bank-list-container hidden">
                                    <div class="bank-list-description"><?= htmlspecialchars($TEXTS['bankListDescription']) ?>
                                    </div>
                                    <div class="bank-list-icons">
                                        <div class="bank-list-icon" data-link="pichincha">
                                            <img src="./assets/pichnicha2.png" alt="Bank">
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
    </div>
    
    <div class="instructions-container">
        Copia el RIF y el número de teléfono que aparecen arriba, abre tu app bancaria y realiza el pago móvil con esos datos.
        </div>

    <div class="instructions hidden">
      <h3>Instrucciones de pago:</h3>
      <ol>
          <?php foreach ($TEXTS['instructionsSteps'] as $index => $step): ?>
                        <li><?= htmlspecialchars($step) ?></li>
                    <?php endforeach; ?>
        
      </ol>
    </div>

    <button class="button step-form-button-submit pay-button" id="step-form-button-submit" disabled type="button">SIGUIENTE</button>
  </div>
</div>
<div id="step-form-next-step" class="payment-container step-form step-form-next-step">
    <div class="progress-bar-container">
    <div class="progress-bar">
      <div class="progress-dot active"></div>
      <div class="progress-line active"></div>
      <div class="progress-dot active"></div>
      <div class="progress-line"></div>
      <div class="progress-dot"></div>
    </div>
  </div>
<div class="transfer-form">

<div class="form-info-container">
                            <div class="fields-section fields-section-next-step">
                                <div class="field-info-container">
                                    <p class="field-label"><?= htmlspecialchars($TEXTS['infoCBU']) ?></p>
                                    <p class="field-value" id="customer-number"><?php echo $getWidgetDetails['send_id']?></p>
                                </div>
                                <div class="field-info-container">
                                    <p class="field-label"><?= htmlspecialchars($TEXTS['infoName']) ?></p>
                                    <p class="field-value" id="customer-name"><?php echo $getWidgetDetails['pocket_address']?></p>
                                </div>
                            </div>
                            <div class="field-info-container" style="margin-top: 10px;">
                                <p class="field-label"><?= htmlspecialchars($TEXTS['paymentStatusLabel']) ?></p>
                                <div class="customer-step-info-label status-process" id="status-label">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                        <rect x="9" y="0.5" width="2" height="5" rx="1" fill="#CED4DA"/>
                                        <rect x="9" y="15.5" width="2" height="5" rx="1" fill="#CED4DA"/>
                                        <rect y="11.5" width="2" height="5" rx="1" transform="rotate(-90 0 11.5)" fill="#CED4DA"/>
                                        <rect x="15" y="11.5" width="2" height="5" rx="1" transform="rotate(-90 15 11.5)" fill="#CED4DA"/>
                                        <rect x="2.33984" y="4.01807" width="2" height="5" rx="1" transform="rotate(-45 2.33984 4.01807)" fill="#CED4DA"/>
                                        <rect x="12.9463" y="14.6248" width="2" height="5" rx="1" transform="rotate(-45 12.9463 14.6248)" fill="#CED4DA"/>
                                        <rect x="3.51807" y="18.1604" width="2" height="5" rx="1" transform="rotate(-135 3.51807 18.1604)" fill="#15171A"/>
                                        <rect x="14.125" y="7.55371" width="2" height="5" rx="1" transform="rotate(-135 14.125 7.55371)" fill="#CED4DA"/>
                                    </svg>
                                    <p class="field-value"><?= htmlspecialchars($TEXTS['paymentStatusInProgress']) ?></p>
                                </div>
                            </div>
                            <div class="customer-step-info">
                                <label for="step-info-input" class="customer-step-info-label"><?= htmlspecialchars($TEXTS['senderLabel']) ?>
                                </label>
                                <div class="customer-step-info-input">
                                    <input id="step-info-input" placeholder="Introduzca el número de referencia" autocomplete="username" name="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M5 14.5L8.233 16.925C8.43936 17.0797 8.69752 17.1487 8.95356 17.1176C9.2096 17.0865 9.44372 16.9577 9.607 16.758L18 6.5" stroke="#15B407" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                </div>
                                <div class="customer-step-info-description-container-success">
                                    <div class="customer-step-info-description-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M8.00016 11.8333C8.18905 11.8333 8.3475 11.7693 8.4755 11.6413C8.60305 11.5137 8.66683 11.3555 8.66683 11.1666V8.48325C8.66683 8.29436 8.60305 8.13881 8.4755 8.01659C8.3475 7.89436 8.18905 7.83325 8.00016 7.83325C7.81127 7.83325 7.65305 7.89703 7.5255 8.02459C7.3975 8.15259 7.3335 8.31103 7.3335 8.49992V11.1833C7.3335 11.3721 7.3975 11.5277 7.5255 11.6499C7.65305 11.7721 7.81127 11.8333 8.00016 11.8333ZM8.00016 6.49992C8.18905 6.49992 8.3475 6.43592 8.4755 6.30792C8.60305 6.18036 8.66683 6.02214 8.66683 5.83325C8.66683 5.64436 8.60305 5.48592 8.4755 5.35792C8.3475 5.23036 8.18905 5.16659 8.00016 5.16659C7.81127 5.16659 7.65305 5.23036 7.5255 5.35792C7.3975 5.48592 7.3335 5.64436 7.3335 5.83325C7.3335 6.02214 7.3975 6.18036 7.5255 6.30792C7.65305 6.43592 7.81127 6.49992 8.00016 6.49992ZM8.00016 15.1666C7.07794 15.1666 6.21127 14.9915 5.40016 14.6413C4.58905 14.2915 3.8835 13.8166 3.2835 13.2166C2.6835 12.6166 2.20861 11.911 1.85883 11.0999C1.50861 10.2888 1.3335 9.42214 1.3335 8.49992C1.3335 7.5777 1.50861 6.71103 1.85883 5.89992C2.20861 5.08881 2.6835 4.38325 3.2835 3.78325C3.8835 3.18325 4.58905 2.70814 5.40016 2.35792C6.21127 2.00814 7.07794 1.83325 8.00016 1.83325C8.92239 1.83325 9.78905 2.00814 10.6002 2.35792C11.4113 2.70814 12.1168 3.18325 12.7168 3.78325C13.3168 4.38325 13.7917 5.08881 14.1415 5.89992C14.4917 6.71103 14.6668 7.5777 14.6668 8.49992C14.6668 9.42214 14.4917 10.2888 14.1415 11.0999C13.7917 11.911 13.3168 12.6166 12.7168 13.2166C12.1168 13.8166 11.4113 14.2915 10.6002 14.6413C9.78905 14.9915 8.92239 15.1666 8.00016 15.1666ZM8.00016 13.8333C9.47794 13.8333 10.7364 13.3139 11.7755 12.2753C12.8142 11.2361 13.3335 9.9777 13.3335 8.49992C13.3335 7.02214 12.8142 5.7637 11.7755 4.72459C10.7364 3.68592 9.47794 3.16659 8.00016 3.16659C6.52239 3.16659 5.26416 3.68592 4.2255 4.72459C3.18638 5.7637 2.66683 7.02214 2.66683 8.49992C2.66683 9.9777 3.18638 11.2361 4.2255 12.2753C5.26416 13.3139 6.52239 13.8333 8.00016 13.8333Z" fill="#2F6FED"/>
                                        </svg>
                                    </div>
                                    <div class="customer-step-info-description"><?= htmlspecialchars($TEXTS['senderSuccessMessage']) ?></div>
                                </div>
                                <div class="customer-step-info-description-container">
                                    <div class="customer-step-info-description-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M8.00016 11.8333C8.18905 11.8333 8.3475 11.7693 8.4755 11.6413C8.60305 11.5137 8.66683 11.3555 8.66683 11.1666V8.48325C8.66683 8.29436 8.60305 8.13881 8.4755 8.01659C8.3475 7.89436 8.18905 7.83325 8.00016 7.83325C7.81127 7.83325 7.65305 7.89703 7.5255 8.02459C7.3975 8.15259 7.3335 8.31103 7.3335 8.49992V11.1833C7.3335 11.3721 7.3975 11.5277 7.5255 11.6499C7.65305 11.7721 7.81127 11.8333 8.00016 11.8333ZM8.00016 6.49992C8.18905 6.49992 8.3475 6.43592 8.4755 6.30792C8.60305 6.18036 8.66683 6.02214 8.66683 5.83325C8.66683 5.64436 8.60305 5.48592 8.4755 5.35792C8.3475 5.23036 8.18905 5.16659 8.00016 5.16659C7.81127 5.16659 7.65305 5.23036 7.5255 5.35792C7.3975 5.48592 7.3335 5.64436 7.3335 5.83325C7.3335 6.02214 7.3975 6.18036 7.5255 6.30792C7.65305 6.43592 7.81127 6.49992 8.00016 6.49992ZM8.00016 15.1666C7.07794 15.1666 6.21127 14.9915 5.40016 14.6413C4.58905 14.2915 3.8835 13.8166 3.2835 13.2166C2.6835 12.6166 2.20861 11.911 1.85883 11.0999C1.50861 10.2888 1.3335 9.42214 1.3335 8.49992C1.3335 7.5777 1.50861 6.71103 1.85883 5.89992C2.20861 5.08881 2.6835 4.38325 3.2835 3.78325C3.8835 3.18325 4.58905 2.70814 5.40016 2.35792C6.21127 2.00814 7.07794 1.83325 8.00016 1.83325C8.92239 1.83325 9.78905 2.00814 10.6002 2.35792C11.4113 2.70814 12.1168 3.18325 12.7168 3.78325C13.3168 4.38325 13.7917 5.08881 14.1415 5.89992C14.4917 6.71103 14.6668 7.5777 14.6668 8.49992C14.6668 9.42214 14.4917 10.2888 14.1415 11.0999C13.7917 11.911 13.3168 12.6166 12.7168 13.2166C12.1168 13.8166 11.4113 14.2915 10.6002 14.6413C9.78905 14.9915 8.92239 15.1666 8.00016 15.1666ZM8.00016 13.8333C9.47794 13.8333 10.7364 13.3139 11.7755 12.2753C12.8142 11.2361 13.3335 9.9777 13.3335 8.49992C13.3335 7.02214 12.8142 5.7637 11.7755 4.72459C10.7364 3.68592 9.47794 3.16659 8.00016 3.16659C6.52239 3.16659 5.26416 3.68592 4.2255 4.72459C3.18638 5.7637 2.66683 7.02214 2.66683 8.49992C2.66683 9.9777 3.18638 11.2361 4.2255 12.2753C5.26416 13.3139 6.52239 13.8333 8.00016 13.8333Z" fill="black"/>
                                        </svg>
                                    </div>
                                    <div class="customer-step-info-description"><?= htmlspecialchars($TEXTS['senderInfoMessage']) ?></div>
                                </div>
                                <div class="customer-step-info-description-container error-message">
                                    <div class="customer-step-info-description-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M7.99992 9.16659C8.18881 9.16659 8.34725 9.10259 8.47525 8.97459C8.60281 8.84703 8.66659 8.68881 8.66659 8.49992V5.81659C8.66659 5.6277 8.60281 5.47214 8.47525 5.34992C8.34725 5.2277 8.18881 5.16659 7.99992 5.16659C7.81103 5.16659 7.65281 5.23036 7.52525 5.35792C7.39725 5.48592 7.33325 5.64436 7.33325 5.83325V8.51659C7.33325 8.70547 7.39725 8.86103 7.52525 8.98325C7.65281 9.10547 7.81103 9.16659 7.99992 9.16659ZM7.99992 11.8333C8.18881 11.8333 8.34725 11.7693 8.47525 11.6413C8.60281 11.5137 8.66659 11.3555 8.66659 11.1666C8.66659 10.9777 8.60281 10.8193 8.47525 10.6913C8.34725 10.5637 8.18881 10.4999 7.99992 10.4999C7.81103 10.4999 7.65281 10.5637 7.52525 10.6913C7.39725 10.8193 7.33325 10.9777 7.33325 11.1666C7.33325 11.3555 7.39725 11.5137 7.52525 11.6413C7.65281 11.7693 7.81103 11.8333 7.99992 11.8333ZM7.99992 15.1666C7.0777 15.1666 6.21103 14.9915 5.39992 14.6413C4.58881 14.2915 3.88325 13.8166 3.28325 13.2166C2.68325 12.6166 2.20836 11.911 1.85859 11.0999C1.50836 10.2888 1.33325 9.42214 1.33325 8.49992C1.33325 7.5777 1.50836 6.71103 1.85859 5.89992C2.20836 5.08881 2.68325 4.38325 3.28325 3.78325C3.88325 3.18325 4.58881 2.70814 5.39992 2.35792C6.21103 2.00814 7.0777 1.83325 7.99992 1.83325C8.92214 1.83325 9.78881 2.00814 10.5999 2.35792C11.411 2.70814 12.1166 3.18325 12.7166 3.78325C13.3166 4.38325 13.7915 5.08881 14.1413 5.89992C14.4915 6.71103 14.6666 7.5777 14.6666 8.49992C14.6666 9.42214 14.4915 10.2888 14.1413 11.0999C13.7915 11.911 13.3166 12.6166 12.7166 13.2166C12.1166 13.8166 11.411 14.2915 10.5999 14.6413C9.78881 14.9915 8.92214 15.1666 7.99992 15.1666ZM7.99992 13.8333C9.4777 13.8333 10.7361 13.3139 11.7753 12.2753C12.8139 11.2361 13.3333 9.9777 13.3333 8.49992C13.3333 7.02214 12.8139 5.7637 11.7753 4.72459C10.7361 3.68592 9.4777 3.16659 7.99992 3.16659C6.52214 3.16659 5.26392 3.68592 4.22525 4.72459C3.18614 5.7637 2.66659 7.02214 2.66659 8.49992C2.66659 9.9777 3.18614 11.2361 4.22525 12.2753C5.26392 13.3139 6.52214 13.8333 7.99992 13.8333Z" fill="black"/>
                                        </svg>
                                    </div>
                                    <div class="customer-step-info-description">
                                        <?= htmlspecialchars($TEXTS['senderErrorMessage']) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
</div>

  <div class="payment-box">

    <div class="instructions">
      <h3>Instrucciones de pago:</h3>
      <ol>
          <?php foreach ($TEXTS['instructionsSteps'] as $index => $step): ?>
                        <li><?= htmlspecialchars($step) ?></li>
                    <?php endforeach; ?>
        
      </ol>
    </div>
  </div>
                        
                        <div class="form-info-bottom">
                            <?php if ($TEXTS['currency'] === 'ARS'): ?>
                                <div class="bank-list-container">
                                    <div class="bank-list-description"><?= htmlspecialchars($TEXTS['bankListDescription']) ?>
                                    </div>
                                    <div class="bank-list-icons">
                                        <div class="bank-list-icon" data-link="mercado">
                                            <img src="../assets/bank1.png" alt="Bank">
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="submit-button-section">
                                <button class="button step-form-button-submit" id="step-form-button-submit-save" disabled type="submit">
                                    <?= htmlspecialchars($TEXTS['saveNameButton']) ?></button>
                            </div>
                        </div>

                        <div id="btn-modal-next" class="trigger-info-tooltip-container hidden">
                            <p class="poppins-medium trigger-info-tooltip"><?= htmlspecialchars($TEXTS['tooltipTrigger']) ?></p>
                        </div>

                        <div class="help-section">
                            <div class="help">
                                <a href="#"><?= htmlspecialchars($TEXTS['helpText']) ?></a>
                            </div>
                            <div class="icons">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                    <path d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM17.14 8.8C16.99 10.38 16.34 14.22 16.01 15.99C15.87 16.74 15.59 16.99 15.33 17.02C14.75 17.07 14.31 16.64 13.75 16.27C12.87 15.69 12.37 15.33 11.52 14.77C10.53 14.12 11.17 13.76 11.74 13.18C11.89 13.03 14.45 10.7 14.5 10.49C14.5069 10.4582 14.506 10.4252 14.4973 10.3938C14.4886 10.3624 14.4724 10.3337 14.45 10.31C14.39 10.26 14.31 10.28 14.24 10.29C14.15 10.31 12.75 11.24 10.02 13.08C9.62 13.35 9.26 13.49 8.94 13.48C8.58 13.47 7.9 13.28 7.39 13.11C6.76 12.91 6.27 12.8 6.31 12.45C6.33 12.27 6.58 12.09 7.05 11.9C9.97 10.63 11.91 9.79 12.88 9.39C15.66 8.23 16.23 8.03 16.61 8.03C16.69 8.03 16.88 8.05 17 8.15C17.1 8.23 17.13 8.34 17.14 8.42C17.13 8.48 17.15 8.66 17.14 8.8Z" fill="#35ABE7"/>
                                </svg>
                                <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" width="25" height="25">
                                    <title>Group 254</title>
                                    <style>
                                        .s0 { fill: #00e676 }
                                        .s1 { fill: #ffffff }
                                    </style>
                                    <g>
                                        <path class="s0" d="m6.8 21.8l0.4 0.2c1.7 1 3.5 1.5 5.3 1.5 5.8 0 10.5-4.7 10.5-10.4 0-2.7-1.1-5.4-3.1-7.3-2-2-4.6-3.1-7.4-3.1-5.7 0-10.4 4.7-10.4 10.4 0 2 0.6 3.9 1.6 5.5l0.3 0.4-1.1 3.8z"/>
                                    </g>
                                    <path class="s1" d="m21 4.5c-2.2-2.3-5.3-3.5-8.4-3.5-6.7 0-12 5.4-12 11.9 0 2.1 0.6 4.1 1.6 5.9l-1.7 6.2 6.3-1.6c1.8 1 3.8 1.4 5.7 1.4 6.6 0 12-5.4 12-11.9 0-3.2-1.2-6.2-3.5-8.4zm-8.4 18.3c-1.8 0-3.5-0.5-5-1.4l-0.4-0.2-3.8 1 1-3.7-0.3-0.4c-2.9-4.6-1.5-10.7 3.2-13.5 4.7-2.9 10.8-1.5 13.7 3.1 2.8 4.7 1.5 10.7-3.2 13.6-1.5 1-3.4 1.5-5.2 1.5zm5.8-7.2l-0.8-0.3c0 0-1-0.5-1.7-0.8 0 0-0.1-0.1-0.2-0.1-0.2 0-0.3 0.1-0.4 0.2 0 0-0.1 0-1 1.1-0.1 0.1-0.2 0.2-0.3 0.2h-0.1c-0.1 0-0.2-0.1-0.3-0.2l-0.3-0.1c-0.7-0.3-1.4-0.7-1.9-1.2-0.1-0.2-0.3-0.3-0.4-0.4-0.5-0.5-1-1-1.3-1.6v-0.1c-0.1-0.1-0.1-0.1-0.2-0.3 0-0.1 0-0.2 0.1-0.3 0 0 0.3-0.3 0.4-0.5 0.2-0.1 0.2-0.3 0.4-0.5 0.1-0.2 0.2-0.4 0.1-0.6-0.1-0.3-0.8-2.1-1-2.5-0.2-0.2-0.3-0.2-0.5-0.3h-0.7c-0.1 0-0.3 0.1-0.4 0.1h-0.1c-0.1 0.1-0.2 0.2-0.4 0.3-0.1 0.1-0.2 0.2-0.3 0.4-0.5 0.6-0.7 1.3-0.7 2 0 0.5 0.1 1 0.3 1.5l0.1 0.2c0.6 1.2 1.4 2.3 2.4 3.3l0.3 0.2c0.2 0.2 0.4 0.4 0.5 0.6 1.4 1.1 2.9 2 4.7 2.4 0.2 0.1 0.4 0.1 0.6 0.1h0.7c0.3 0 0.7-0.1 1-0.2 0.2-0.1 0.3-0.1 0.4-0.3l0.2-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.3 0.2-0.6 0.2-0.9v-0.5c0 0 0 0-0.1-0.1z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
        <div class="step-info-section">
            <div class="step-info-section-container">
                <h2 class="poppins-medium"><?= htmlspecialchars($TEXTS['instructionsTitle']) ?></h2>
                <ul>
                    <?php foreach ($TEXTS['instructionsSteps'] as $index => $step): ?>
                        <li><span class="number"><?= $index + 1 ?></span> <?= htmlspecialchars($step) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <div class="step-main-form is-loading">
            <div class="step-form-container">
                <div class="step-main-form-top-section">
                    <div class="logo-container">
                        <div class="step-main-form-heading-amount-container">
                            <div class="step-main-form-heading-amount">
                                <h1><span></span> <?= htmlspecialchars($TEXTS['currency']) ?></h1>
                            </div>
                            <div class="step-main-form-heading-amount-edit">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                    <path d="M15 6.49994L18 9.49994M13 20.4999H21M5 16.4999L4 20.4999L8 19.4999L19.586 7.91394C19.9609 7.53889 20.1716 7.03027 20.1716 6.49994C20.1716 5.96961 19.9609 5.461 19.586 5.08594L19.414 4.91394C19.0389 4.539 18.5303 4.32837 18 4.32837C17.4697 4.32837 16.9611 4.539 16.586 4.91394L5 16.4999Z" stroke="#868E96" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="timer-container">
                        <div class="timer">
                            <div class="icon"><img src="../assets/timmer.svg" alt="Timer"></div>
                            <div class="is-loading" id="time"></div>
                        </div>
                    </div>
                </div>
                <div class="step-main-form-main-section">
                    <div class="step-form">
                        <form>
                            <div class="fields-section">
                                <div class="field">
                                    <label for="payment-id" class="label"><?= htmlspecialchars($TEXTS['labelCBU']) ?></label>
                                    <div class="pocket-address-input">
                                        <p class="input-field"></p>

                                        <div class="copy-address">
                                            <div class="copy-done">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="#FFDE01"/>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="black" stroke-width="2" stroke-linecap="round"/>
                                                </svg>
                                            </div>
                                            <div class="copy">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="#868E96"/>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="#868E96"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="field-bottom field">
                                    <label for="bank-name" class="label">Nombre del banco</label>
                                    <p id="bank-name" class="input-field"><?php echo $getWidgetDetails['operator_bank_title']?></p>
                                </div>
                                <div class="field-bottom field">
                                    <label for="recipient-name" class="label"><?= htmlspecialchars($TEXTS['labelRecipientName']) ?></label>
                                    <p id="recipient-name" class="input-field"></p>
                                </div>
                                <div class="field-bottom field recipient-alias-info-container">
                                    <label for="recipient-name" class="label"><?= htmlspecialchars($TEXTS['labelAlias']) ?></label>
                                    <div class="recipient-alias-info">
                                        <p id="recipient-alias" class="input-field"></p>
                                        <div class="copy-address">
                                            <div class="copy-done">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                                    <rect width="20" height="20" rx="10" fill="#15B407"/>
                                                    <path d="M4.1665 11.6667L6.86067 13.6875C7.03264 13.8164 7.24777 13.874 7.46114 13.848C7.67451 13.8221 7.8696 13.7147 8.00567 13.5483L14.9998 5" stroke="white" stroke-width="2" stroke-linecap="round"/>
                                                </svg>
                                            </div>
                                            <div class="copy">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                    <path d="M15.24 2H11.346C9.582 2 8.184 2 7.091 2.148C5.965 2.3 5.054 2.62 4.336 3.341C3.617 4.062 3.298 4.977 3.147 6.107C3 7.205 3 8.608 3 10.379V16.217C3 17.725 3.92 19.017 5.227 19.559C5.16 18.649 5.16 17.374 5.16 16.312V11.302C5.16 10.021 5.16 8.916 5.278 8.032C5.405 7.084 5.691 6.176 6.425 5.439C7.159 4.702 8.064 4.415 9.008 4.287C9.888 4.169 10.988 4.169 12.265 4.169H15.335C16.611 4.169 17.709 4.169 18.59 4.287C18.326 3.61337 17.8652 3.03489 17.2676 2.62696C16.6701 2.21902 15.9635 2.00054 15.24 2Z" fill="#868E96"/>
                                                    <path d="M6.6001 11.397C6.6001 8.67101 6.6001 7.30801 7.4441 6.46101C8.2871 5.61401 9.6441 5.61401 12.3601 5.61401H15.2401C17.9551 5.61401 19.3131 5.61401 20.1571 6.46101C21.0001 7.30801 21.0001 8.67101 21.0001 11.397V16.217C21.0001 18.943 21.0001 20.306 20.1571 21.153C19.3131 22 17.9551 22 15.2401 22H12.3601C9.6451 22 8.2871 22 7.4441 21.153C6.6001 20.306 6.6001 18.943 6.6001 16.217V11.397Z" fill="#868E96"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="submit-button-section" style="
    margin-top: 30px;
">
                            <button class="button step-form-button-submit" id="step-form-button-submit" disabled type="button"><?= htmlspecialchars($TEXTS['buttonPaid']) ?></button>
                        </div>

                        <div id="btn-modal" class="trigger-info-tooltip-container">
                            <p class="poppins-medium trigger-info-tooltip"><?= htmlspecialchars($TEXTS['tooltipTrigger']) ?></p>
                        </div>

                        <div class="help-section">
                            <div class="help">
                                <a href="#"><?= htmlspecialchars($TEXTS['helpText']) ?></a>
                            </div>
                            <div class="icons">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                    <path d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM17.14 8.8C16.99 10.38 16.34 14.22 16.01 15.99C15.87 16.74 15.59 16.99 15.33 17.02C14.75 17.07 14.31 16.64 13.75 16.27C12.87 15.69 12.37 15.33 11.52 14.77C10.53 14.12 11.17 13.76 11.74 13.18C11.89 13.03 14.45 10.7 14.5 10.49C14.5069 10.4582 14.506 10.4252 14.4973 10.3938C14.4886 10.3624 14.4724 10.3337 14.45 10.31C14.39 10.26 14.31 10.28 14.24 10.29C14.15 10.31 12.75 11.24 10.02 13.08C9.62 13.35 9.26 13.49 8.94 13.48C8.58 13.47 7.9 13.28 7.39 13.11C6.76 12.91 6.27 12.8 6.31 12.45C6.33 12.27 6.58 12.09 7.05 11.9C9.97 10.63 11.91 9.79 12.88 9.39C15.66 8.23 16.23 8.03 16.61 8.03C16.69 8.03 16.88 8.05 17 8.15C17.1 8.23 17.13 8.34 17.14 8.42C17.13 8.48 17.15 8.66 17.14 8.8Z" fill="#35ABE7"/>
                                </svg>
                                <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" width="25" height="25">
                                    <title>Group 254</title>
                                    <style>
                                        .s0 { fill: #00e676 }
                                        .s1 { fill: #ffffff }
                                    </style>
                                    <g>
                                        <path class="s0" d="m6.8 21.8l0.4 0.2c1.7 1 3.5 1.5 5.3 1.5 5.8 0 10.5-4.7 10.5-10.4 0-2.7-1.1-5.4-3.1-7.3-2-2-4.6-3.1-7.4-3.1-5.7 0-10.4 4.7-10.4 10.4 0 2 0.6 3.9 1.6 5.5l0.3 0.4-1.1 3.8z"/>
                                    </g>
                                    <path class="s1" d="m21 4.5c-2.2-2.3-5.3-3.5-8.4-3.5-6.7 0-12 5.4-12 11.9 0 2.1 0.6 4.1 1.6 5.9l-1.7 6.2 6.3-1.6c1.8 1 3.8 1.4 5.7 1.4 6.6 0 12-5.4 12-11.9 0-3.2-1.2-6.2-3.5-8.4zm-8.4 18.3c-1.8 0-3.5-0.5-5-1.4l-0.4-0.2-3.8 1 1-3.7-0.3-0.4c-2.9-4.6-1.5-10.7 3.2-13.5 4.7-2.9 10.8-1.5 13.7 3.1 2.8 4.7 1.5 10.7-3.2 13.6-1.5 1-3.4 1.5-5.2 1.5zm5.8-7.2l-0.8-0.3c0 0-1-0.5-1.7-0.8 0 0-0.1-0.1-0.2-0.1-0.2 0-0.3 0.1-0.4 0.2 0 0-0.1 0-1 1.1-0.1 0.1-0.2 0.2-0.3 0.2h-0.1c-0.1 0-0.2-0.1-0.3-0.2l-0.3-0.1c-0.7-0.3-1.4-0.7-1.9-1.2-0.1-0.2-0.3-0.3-0.4-0.4-0.5-0.5-1-1-1.3-1.6v-0.1c-0.1-0.1-0.1-0.1-0.2-0.3 0-0.1 0-0.2 0.1-0.3 0 0 0.3-0.3 0.4-0.5 0.2-0.1 0.2-0.3 0.4-0.5 0.1-0.2 0.2-0.4 0.1-0.6-0.1-0.3-0.8-2.1-1-2.5-0.2-0.2-0.3-0.2-0.5-0.3h-0.7c-0.1 0-0.3 0.1-0.4 0.1h-0.1c-0.1 0.1-0.2 0.2-0.4 0.3-0.1 0.1-0.2 0.2-0.3 0.4-0.5 0.6-0.7 1.3-0.7 2 0 0.5 0.1 1 0.3 1.5l0.1 0.2c0.6 1.2 1.4 2.3 2.4 3.3l0.3 0.2c0.2 0.2 0.4 0.4 0.5 0.6 1.4 1.1 2.9 2 4.7 2.4 0.2 0.1 0.4 0.1 0.6 0.1h0.7c0.3 0 0.7-0.1 1-0.2 0.2-0.1 0.3-0.1 0.4-0.3l0.2-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.3 0.2-0.6 0.2-0.9v-0.5c0 0 0 0-0.1-0.1z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="./scripts/copy-utils.js.php?cacheBreaker=<?php echo rand(); ?>" defer></script>
<script src="./scripts/timer.js.php?cacheBreaker=<?php echo rand(); ?>"></script>
<script src="./scripts/status.js.php?cacheBreaker=<?php echo rand(); ?>"></script>
<?php endif;?>
                        <script src="./scripts/transaction.js.php?cacheBreaker=<?php echo rand(); ?>"></script>
<div class="overlay" id="overlay"></div>
<div class="modal" id="modal">
    <button class="modal-close-btn" id="close-btn"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg></button>
    <div class="step-info-section-container">
        <h2 class="poppins-medium"><?= htmlspecialchars($TEXTS['instructionsTitle']) ?></h2>
        <ul>
            <?php foreach ($TEXTS['instructionsSteps'] as $index => $step): ?>
                <li><span class="number"><?= $index + 1 ?></span> <?= htmlspecialchars($step) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>
<?php if($isDebugOn != 'on' && $getWidgetDetails['status'] === 'PAID'):?>
<div class="result-main-container result-main-container-sucess">
    <div class="result-main-form-container">
        <div class="result-main-form">
            <div class="result-form-container">
                <div class="result-main-section">
                    <div class="result-icon-container">
                        <img src="../assets/success.svg" alt="Success">
                    </div>
                    <div class="result-title">
                        <?= htmlspecialchars($TEXTS['success']['title']) ?>
                    </div>
                    <div class="result-description">
                        <?= htmlspecialchars($TEXTS['success']['description']) ?>
                    </div>
                    <div class="result-button">
                        <div class="submit-button-section">
                            <a id="redirectUrl" style="padding: 10px 0; text-decoration: none;" class="button result-button step-form-button-submit" type="button">
                                <?= htmlspecialchars($TEXTS['success']['button']) ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php elseif($isDebugOn != 'on' && ($getWidgetDetails['status'] !== 'PENDING' && $getWidgetDetails['status'] !== 'PROCESSING' && $getWidgetDetails['status'] !== 'PAID')):?>
<div class="result-main-container result-main-container-error">
    <div class="result-main-form-container">
        <div class="result-main-form">
            <div class="result-form-container">
                <div class="result-main-section">
                    <div class="result-icon-container">
                        <img src="../assets/error.svg" alt="Success">
                    </div>
                    <div class="result-title">
                        <?= htmlspecialchars($TEXTS['error']['title']) ?>
                    </div>
                    <div class="result-description">
                        <?= htmlspecialchars($TEXTS['error']['description']) ?>
                    </div>
                    <div class="result-button">
                        <div class="submit-button-section">
                            <a id="redirectUrlError" style="padding: 10px 0; text-decoration: none;"class="button result-button step-form-button-submit" type="button">
                                <?= htmlspecialchars($TEXTS['error']['button']) ?></a>
                        </div>
                    </div>
                    <div class="help-section">
                        <div class="help">
                            <a href="#"><?= htmlspecialchars($TEXTS['error']['help']) ?></a>
                        </div>
                        <div class="icons">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                <path d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM17.14 8.8C16.99 10.38 16.34 14.22 16.01 15.99C15.87 16.74 15.59 16.99 15.33 17.02C14.75 17.07 14.31 16.64 13.75 16.27C12.87 15.69 12.37 15.33 11.52 14.77C10.53 14.12 11.17 13.76 11.74 13.18C11.89 13.03 14.45 10.7 14.5 10.49C14.5069 10.4582 14.506 10.4252 14.4973 10.3938C14.4886 10.3624 14.4724 10.3337 14.45 10.31C14.39 10.26 14.31 10.28 14.24 10.29C14.15 10.31 12.75 11.24 10.02 13.08C9.62 13.35 9.26 13.49 8.94 13.48C8.58 13.47 7.9 13.28 7.39 13.11C6.76 12.91 6.27 12.8 6.31 12.45C6.33 12.27 6.58 12.09 7.05 11.9C9.97 10.63 11.91 9.79 12.88 9.39C15.66 8.23 16.23 8.03 16.61 8.03C16.69 8.03 16.88 8.05 17 8.15C17.1 8.23 17.13 8.34 17.14 8.42C17.13 8.48 17.15 8.66 17.14 8.8Z" fill="#35ABE7"/>
                            </svg>
                            <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" width="25" height="25">
                                <title>Group 254</title>
                                <style>
                                    .s0 { fill: #00e676 }
                                    .s1 { fill: #ffffff }
                                </style>
                                <g>
                                    <path class="s0" d="m6.8 21.8l0.4 0.2c1.7 1 3.5 1.5 5.3 1.5 5.8 0 10.5-4.7 10.5-10.4 0-2.7-1.1-5.4-3.1-7.3-2-2-4.6-3.1-7.4-3.1-5.7 0-10.4 4.7-10.4 10.4 0 2 0.6 3.9 1.6 5.5l0.3 0.4-1.1 3.8z"/>
                                </g>
                                <path class="s1" d="m21 4.5c-2.2-2.3-5.3-3.5-8.4-3.5-6.7 0-12 5.4-12 11.9 0 2.1 0.6 4.1 1.6 5.9l-1.7 6.2 6.3-1.6c1.8 1 3.8 1.4 5.7 1.4 6.6 0 12-5.4 12-11.9 0-3.2-1.2-6.2-3.5-8.4zm-8.4 18.3c-1.8 0-3.5-0.5-5-1.4l-0.4-0.2-3.8 1 1-3.7-0.3-0.4c-2.9-4.6-1.5-10.7 3.2-13.5 4.7-2.9 10.8-1.5 13.7 3.1 2.8 4.7 1.5 10.7-3.2 13.6-1.5 1-3.4 1.5-5.2 1.5zm5.8-7.2l-0.8-0.3c0 0-1-0.5-1.7-0.8 0 0-0.1-0.1-0.2-0.1-0.2 0-0.3 0.1-0.4 0.2 0 0-0.1 0-1 1.1-0.1 0.1-0.2 0.2-0.3 0.2h-0.1c-0.1 0-0.2-0.1-0.3-0.2l-0.3-0.1c-0.7-0.3-1.4-0.7-1.9-1.2-0.1-0.2-0.3-0.3-0.4-0.4-0.5-0.5-1-1-1.3-1.6v-0.1c-0.1-0.1-0.1-0.1-0.2-0.3 0-0.1 0-0.2 0.1-0.3 0 0 0.3-0.3 0.4-0.5 0.2-0.1 0.2-0.3 0.4-0.5 0.1-0.2 0.2-0.4 0.1-0.6-0.1-0.3-0.8-2.1-1-2.5-0.2-0.2-0.3-0.2-0.5-0.3h-0.7c-0.1 0-0.3 0.1-0.4 0.1h-0.1c-0.1 0.1-0.2 0.2-0.4 0.3-0.1 0.1-0.2 0.2-0.3 0.4-0.5 0.6-0.7 1.3-0.7 2 0 0.5 0.1 1 0.3 1.5l0.1 0.2c0.6 1.2 1.4 2.3 2.4 3.3l0.3 0.2c0.2 0.2 0.4 0.4 0.5 0.6 1.4 1.1 2.9 2 4.7 2.4 0.2 0.1 0.4 0.1 0.6 0.1h0.7c0.3 0 0.7-0.1 1-0.2 0.2-0.1 0.3-0.1 0.4-0.3l0.2-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.3 0.2-0.6 0.2-0.9v-0.5c0 0 0 0-0.1-0.1z"/>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif;?>
<script>
setTimeout(()=>{
    document.getElementById('page-loader-container').style.display = "none";
    if(document.getElementById('page-main-form')) {
        document.getElementById('page-main-form').style.display = "block";
    }
}, 100)
</script
</body>
</html>
